/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.provider.KeyAdjuster;
import au.org.ala.names.index.provider.ScoreAdjuster;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NameProvider {
    public static final int DEFAULT_SCORE = 100;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String rightsHolder;
    @JsonProperty
    private String licence;
    @JsonProperty
    private NameProvider parent;
    @JsonProperty
    private Integer defaultScore;
    @JsonProperty
    private Map<String, Integer> scores;
    @JsonProperty
    private Set<String> owner;
    @JsonProperty
    private ScoreAdjuster adjuster;
    @JsonProperty
    private KeyAdjuster keyAdjuster;
    @JsonProperty
    private NomenclaturalCode defaultNomenclaturalCode;
    @JsonProperty
    private boolean loose;
    @JsonProperty
    private boolean external;

    public NameProvider() {
        this.name = this.id = UUID.randomUUID().toString();
        this.description = null;
        this.rightsHolder = null;
        this.licence = null;
        this.parent = null;
        this.defaultScore = null;
        this.defaultNomenclaturalCode = null;
        this.scores = new HashMap<String, Integer>();
        this.owner = new HashSet<String>();
        this.adjuster = new ScoreAdjuster();
        this.keyAdjuster = new KeyAdjuster();
        this.loose = false;
        this.external = true;
    }

    public NameProvider(String id, Integer defaultScore, Map<String, Integer> scores) {
        this.name = this.id = id;
        this.description = null;
        this.rightsHolder = null;
        this.licence = null;
        this.parent = null;
        this.defaultScore = defaultScore;
        this.defaultNomenclaturalCode = null;
        this.scores = scores;
        this.owner = new HashSet<String>();
        this.adjuster = new ScoreAdjuster();
        this.keyAdjuster = new KeyAdjuster();
        this.loose = false;
        this.external = true;
    }

    public NameProvider(String id, String name, NameProvider parent, boolean loose) {
        if (parent == this) {
            throw new IllegalArgumentException("Parent same as child for " + id);
        }
        this.id = id;
        this.name = name;
        this.description = null;
        this.rightsHolder = null;
        this.licence = null;
        this.parent = parent;
        this.defaultScore = parent.getDefaultScore();
        this.defaultNomenclaturalCode = null;
        this.scores = new HashMap<String, Integer>();
        this.owner = new HashSet<String>();
        this.adjuster = new ScoreAdjuster();
        this.keyAdjuster = new KeyAdjuster();
        this.loose = loose;
        this.external = true;
    }

    public NameProvider(String id, int defaultScore) {
        this(id, defaultScore, Collections.EMPTY_MAP);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRightsHolder() {
        if (this.rightsHolder == null && this.parent != null) {
            return this.parent.getRightsHolder();
        }
        return this.rightsHolder;
    }

    public String getLicence() {
        if (this.licence == null && this.parent != null) {
            return this.parent.getLicence();
        }
        return this.licence;
    }

    public NameProvider getParent() {
        return this.parent;
    }

    public boolean isLoose() {
        return this.loose;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean forbid(TaxonConceptInstance instance) {
        if (this.parent != null && this.parent.forbid(instance)) {
            return true;
        }
        return this.adjuster.forbid(instance);
    }

    public boolean owns(String name) {
        return this.owner.contains(name);
    }

    @JsonIgnore
    public int getDefaultScore() {
        if (this.defaultScore != null) {
            return this.defaultScore;
        }
        if (this.parent != null) {
            return this.parent.getDefaultScore();
        }
        return 100;
    }

    @JsonIgnore
    public NomenclaturalCode getDefaultNomenclaturalCode() {
        if (this.defaultNomenclaturalCode != null) {
            return this.defaultNomenclaturalCode;
        }
        if (this.parent != null) {
            return this.parent.getDefaultNomenclaturalCode();
        }
        return null;
    }

    public Integer getSpecificScore(String name) {
        Integer specific = this.scores.get(name);
        if (specific != null) {
            return specific;
        }
        if (this.parent != null) {
            specific = this.parent.getSpecificScore(name);
        }
        return specific == null ? null : Integer.valueOf(Math.max(-1000000, Math.min(1000000, specific)));
    }

    public int computeBaseScore(TaxonConceptInstance original, TaxonConceptInstance instance) {
        Integer specific = this.getSpecificScore(instance.getScientificName());
        if (specific != null) {
            return specific;
        }
        TaxonConceptInstance p = instance.getParent() == null ? null : instance.getParent().getRepresentative();
        int score = p != null ? p.getBaseScore(original) : this.getDefaultScore();
        return Math.max(-1000000, Math.min(1000000, score));
    }

    public int computeScore(TaxonConceptInstance instance) {
        if (this.owns(instance.getScientificName())) {
            return 1000000;
        }
        if (instance.isForbidden()) {
            return -1000000;
        }
        int score = instance.getBaseScore();
        score = this.adjustScore(score, instance);
        return Math.max(-1000000, Math.min(1000000, score));
    }

    public int adjustScore(int score, TaxonConceptInstance instance) {
        if (this.parent != null) {
            score = this.parent.adjustScore(score, instance);
        }
        return this.adjuster == null ? score : this.adjuster.score(score, instance);
    }

    public NameKey adjustKey(NameKey key, TaxonConceptInstance instance) {
        if (this.parent != null) {
            key = this.parent.adjustKey(key, instance);
        }
        return this.keyAdjuster == null ? key : this.keyAdjuster.adjustKey(key, instance);
    }

    @JsonIgnore
    public Citation getCitation() throws IndexBuilderException {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
        }
        if (this.getRightsHolder() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getRightsHolder());
        }
        return new Citation(sb.toString(), this.getId());
    }

    @JsonIgnore
    public Map<Term, String> getProviderMap() {
        LinkedHashMap<Term, String> map = new LinkedHashMap<Term, String>();
        map.put((Term)DwcTerm.datasetID, this.getId());
        map.put((Term)DwcTerm.datasetName, this.getName());
        map.put((Term)DcTerm.description, this.getDescription());
        map.put((Term)DcTerm.rightsHolder, this.getRightsHolder());
        map.put((Term)DcTerm.license, this.getLicence());
        return map;
    }
}

