/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.model.RankType;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalCode;

public class NameKey
implements Comparable<NameKey> {
    private NameAnalyser analyser;
    private NomenclaturalCode code;
    private String scientificName;
    private String scientificNameAuthorship;
    private RankType rank;
    private NameType type;

    public NameKey(NameAnalyser analyser, NomenclaturalCode code, String scientificName, String scientificNameAuthorship, RankType rank, NameType type) {
        this.analyser = analyser;
        this.code = code;
        this.scientificName = scientificName;
        this.scientificNameAuthorship = scientificNameAuthorship;
        this.rank = rank;
        this.type = type;
    }

    public NameAnalyser getAnalyser() {
        return this.analyser;
    }

    public NomenclaturalCode getCode() {
        return this.code;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    public RankType getRank() {
        return this.rank;
    }

    public NameType getType() {
        return this.type;
    }

    public boolean isUncoded() {
        return this.code == null;
    }

    public boolean isUnranked() {
        return this.rank == null || this.rank == RankType.UNRANKED;
    }

    public boolean isFormal() {
        return this.code != null && this.type != null && (this.type == NameType.SCIENTIFIC || this.type == NameType.HYBRID || this.type == NameType.CULTIVAR || this.type == NameType.VIRUS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameKey nameKey = (NameKey)o;
        return this.analyser.compare(this, nameKey) == 0;
    }

    public int hashCode() {
        return this.analyser.hashCode(this);
    }

    public NameKey toNameKey() {
        if (this.scientificNameAuthorship == null) {
            return this;
        }
        return new NameKey(this.analyser, this.code, this.scientificName, null, this.rank, this.type);
    }

    public NameKey toUnrankedNameKey() {
        if (this.scientificNameAuthorship == null && this.rank == RankType.UNRANKED) {
            return this;
        }
        return new NameKey(this.analyser, this.code, this.scientificName, null, RankType.UNRANKED, this.type);
    }

    public NameKey toUncodedNameKey() {
        if (this.scientificNameAuthorship == null && this.rank == RankType.UNRANKED && this.code == null) {
            return this;
        }
        return new NameKey(this.analyser, null, this.scientificName, null, RankType.UNRANKED, this.type);
    }

    public String toString() {
        return "[" + (this.code != null ? this.code.getAcronym() : "") + ":" + this.scientificName + (this.scientificNameAuthorship != null ? "," + this.scientificNameAuthorship : "") + ":" + this.rank.getRank() + ']';
    }

    @Override
    public int compareTo(NameKey o) {
        return this.analyser.compare(this, o);
    }
}

