/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonResolution;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.model.TaxonomicTypeGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ALATaxonResolver
implements TaxonResolver {
    private Taxonomy taxonomy;

    public ALATaxonResolver(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    @Override
    public List<TaxonConceptInstance> principals(TaxonConcept concept, Collection<TaxonConceptInstance> instances) throws IndexBuilderException {
        Optional<TaxonConceptInstance> max;
        Optional<NameProvider> provider;
        int cutoff = this.taxonomy.getAcceptedCutoff();
        List<TaxonConceptInstance> principals = instances.stream().filter(tci -> tci.isPrimary() && tci.getScore() > cutoff).collect(Collectors.toList());
        if (principals.isEmpty()) {
            this.taxonomy.report(IssueType.NOTE, "taxonResolver.noPrincipals", concept);
            principals = new ArrayList<TaxonConceptInstance>(instances);
        }
        if (!(provider = (max = principals.stream().max(TaxonConceptInstance.SCORE_COMPARATOR)).map(TaxonConceptInstance::getProvider)).isPresent()) {
            this.taxonomy.report(IssueType.NOTE, "taxonResolver.noProvider", concept);
            max = instances.stream().max(TaxonConceptInstance.SCORE_COMPARATOR);
            provider = max.map(TaxonConceptInstance::getProvider);
            principals = new ArrayList<TaxonConceptInstance>(instances);
        }
        NameProvider source = provider.orElse(this.taxonomy.getInferenceProvider());
        principals = principals.stream().filter(instance -> instance.getProvider() == source).collect(Collectors.toList());
        principals.sort(TaxonConceptInstance.INVERSE_SCORE_COMPARATOR);
        return principals;
    }

    @Override
    public TaxonResolution resolve(TaxonConcept concept, List<TaxonConceptInstance> principals, Collection<TaxonConceptInstance> instances) throws IndexBuilderException {
        TaxonResolution resolution = new TaxonResolution(principals);
        for (TaxonConceptInstance instance : instances) {
            this.resolve(instance, resolution);
        }
        return resolution;
    }

    protected void resolve(TaxonConceptInstance instance, TaxonResolution resolution) throws IndexBuilderException {
        ScientificName acceptedScientificName;
        TaxonomicType taxonomicStatus = instance.getTaxonomicStatus();
        TaxonomicTypeGroup taxonomicGroup = taxonomicStatus.getGroup();
        TaxonConcept taxonConcept = (TaxonConcept)instance.getContainer();
        ScientificName scientificName = taxonConcept == null ? null : (ScientificName)taxonConcept.getContainer();
        TaxonConceptInstance accepted = instance.getAccepted() == null ? null : instance.getAccepted().getRepresentative();
        TaxonConcept acceptedTaxonConcept = accepted == null ? null : (TaxonConcept)accepted.getContainer();
        ScientificName scientificName2 = acceptedScientificName = acceptedTaxonConcept == null ? null : (ScientificName)acceptedTaxonConcept.getContainer();
        if (resolution.getPrincipal().contains(instance)) {
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (instance.isAccepted() && instance.isPrimary()) {
            TaxonConceptInstance r;
            Optional<TaxonConceptInstance> resolved = resolution.getUsed().stream().filter(tci -> tci.isAccepted() && tci.getContainer() == taxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.isAccepted() && ((TaxonConcept)tci.getContainer()).getContainer() == scientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.isAccepted()).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            List<TaxonConceptInstance> synonyms = resolution.getUsed().stream().filter(tci -> tci.isSynonym() && !tci.isForbidden()).collect(Collectors.toList());
            if (!synonyms.isEmpty() && (r = this.lub(synonyms)) != null) {
                this.taxonomy.report(IssueType.NOTE, "taxonResolver.synonyms", instance, r);
                resolution.addExternal(instance, r, this.taxonomy);
                return;
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (instance.isSynonym() && instance.isPrimary() && accepted != null) {
            Optional<TaxonConceptInstance> resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && tci.getAccepted().getContainer() == acceptedTaxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus().getGroup() == taxonomicGroup && tci.getAccepted() != null && tci.getAccepted().getContainer() == acceptedTaxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && ((TaxonomicElement)tci.getAccepted().getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus().getGroup() == taxonomicGroup && tci.getAccepted() != null && ((TaxonomicElement)tci.getAccepted().getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            List<TaxonConceptInstance> synonyms = resolution.getUsed().stream().filter(tci -> tci.isSynonym() && !tci.isForbidden()).collect(Collectors.toList());
            if (!synonyms.isEmpty()) {
                TaxonConceptInstance r;
                TaxonConceptInstance taxonConceptInstance = r = synonyms.size() == 1 ? (TaxonConceptInstance)synonyms.get(0) : this.lub(synonyms);
                if (r != null) {
                    this.taxonomy.report(IssueType.NOTE, "taxonResolver.synonyms", instance, r);
                    resolution.addExternal(instance, r, this.taxonomy);
                    return;
                }
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        if (instance.getAccepted() != null) {
            Optional<TaxonConceptInstance> resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && tci.getAccepted().getContainer() == acceptedTaxonConcept).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus && tci.getAccepted() != null && ((TaxonomicElement)tci.getAccepted().getContainer()).getContainer() == acceptedScientificName).findFirst();
            if (resolved.isPresent()) {
                resolution.addInternal(instance, resolved.get(), this.taxonomy);
                return;
            }
            resolution.addInternal(instance, instance, this.taxonomy);
            return;
        }
        Optional<TaxonConceptInstance> resolved = resolution.getUsed().stream().filter(tci -> tci.getTaxonomicStatus() == taxonomicStatus).findFirst();
        if (resolved.isPresent()) {
            resolution.addInternal(instance, resolved.get(), this.taxonomy);
            return;
        }
        resolution.addInternal(instance, instance, this.taxonomy);
    }

    public TaxonConceptInstance lub(TaxonConceptInstance i1, TaxonConceptInstance i2) {
        while (i1 != null) {
            TaxonConceptInstance r1 = i1.getAccepted() == null ? i1 : i1.getAccepted().getRepresentative();
            TaxonConceptInstance p2 = i2;
            while (p2 != null) {
                TaxonConceptInstance taxonConceptInstance = p2 = p2.getAccepted() == null ? p2 : p2.getAccepted().getRepresentative();
                if (p2.getContainer() == r1.getContainer()) {
                    return r1;
                }
                p2 = p2.getParent() == null ? null : p2.getParent().getRepresentative();
            }
            i1 = i1.getParent() == null ? null : i1.getParent().getRepresentative();
        }
        return null;
    }

    public TaxonConceptInstance lub(Collection<TaxonConceptInstance> instances) {
        TaxonConceptInstance lub;
        Iterator<TaxonConceptInstance> i = instances.iterator();
        TaxonConceptInstance taxonConceptInstance = lub = i.hasNext() ? i.next() : null;
        while (i.hasNext() && lub != null) {
            lub = this.lub(lub, i.next());
        }
        return lub;
    }
}

