/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata.parse.converter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URL;
import org.apache.commons.beanutils.converters.AbstractConverter;

public final class GreedyUriConverter
extends AbstractConverter {
    public static final String DEFAULT_PROTOCOL = "http://";

    public GreedyUriConverter() {
    }

    public GreedyUriConverter(Object defaultValue) {
        super(defaultValue);
    }

    protected Object convertToType(Class type, Object value) {
        Preconditions.checkNotNull(value, "Must provide a type to convert to null");
        String valueAsString = Strings.emptyToNull(CharMatcher.WHITESPACE.trimFrom(String.valueOf(value)));
        URI uri = null;
        if (!Strings.isNullOrEmpty(valueAsString)) {
            try {
                uri = URI.create(valueAsString);
                if (uri.getScheme() == null || uri.isOpaque()) {
                    try {
                        uri = URI.create(DEFAULT_PROTOCOL + valueAsString);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return uri;
    }

    protected Class getDefaultType() {
        return URI.class;
    }

    public URI convert(String value) {
        return (URI)this.convertToType(URL.class, value);
    }
}

