/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Organization;
import org.gbif.api.model.registry.eml.temporal.DateRange;
import org.gbif.api.model.registry.eml.temporal.SingleDate;
import org.gbif.api.model.registry.eml.temporal.TemporalCoverage;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriod;
import org.gbif.api.util.formatter.TemporalCoverageFormatterVisitor;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.registry.metadata.DatasetXMLWriterConfigurationProvider;
import org.gbif.registry.metadata.contact.ContactAdapter;

public class DublinCoreWriter {
    public static final String ADDITIONAL_PROPERTY_OCC_COUNT = "occurrence_count";
    public static final String ADDITIONAL_PROPERTY_DC_FORMAT = "dublincore_format";
    private static final String DC_TEMPLATE = "oai-dc-profile-template/dc-dataset.ftl";
    private final Configuration freemarkerConfig;
    private static final String IDENTIFIER_PREFIX = "http://www.gbif.org/dataset/";
    private static final FastDateFormat FDF = DateFormatUtils.ISO_DATE_FORMAT;
    private static final TemporalCoverageFormatterVisitor TC_FORMATTER = new DcTemporalTemporalCoverageFormatter();

    private DublinCoreWriter(Configuration cfg) {
        this.freemarkerConfig = cfg;
    }

    public static DublinCoreWriter newInstance() {
        return new DublinCoreWriter(DatasetXMLWriterConfigurationProvider.provideFreemarker());
    }

    public void writeTo(@Nullable Organization organization, @NotNull Dataset dataset, Map<String, Object> additionalProperties, Writer writer) throws IOException {
        Preconditions.checkNotNull(dataset, "Dataset can't be null");
        Map<String, Object> map = Maps.newHashMap();
        map.put("dataset", dataset);
        map.put("dc", new DcDatasetWrapper(dataset, additionalProperties));
        if (organization != null) {
            map.put("organization", organization);
        }
        map = ImmutableMap.copyOf(map);
        try {
            this.freemarkerConfig.getTemplate(DC_TEMPLATE).process(map, writer);
        }
        catch (TemplateException e) {
            throw new IOException("Error while processing the DublinCore Freemarker template for dataset " + dataset.getKey(), e);
        }
    }

    private static class DcTemporalTemporalCoverageFormatter
    implements TemporalCoverageFormatterVisitor {
        private DcTemporalTemporalCoverageFormatter() {
        }

        public String format(DateRange dateRange) {
            String startDate = dateRange.getStart() != null ? FDF.format(dateRange.getStart()) : "";
            String endDate = dateRange.getEnd() != null ? FDF.format(dateRange.getEnd()) : "";
            return startDate + "/" + endDate;
        }

        public String format(SingleDate singleDate) {
            if (singleDate.getDate() == null) {
                return "";
            }
            return FDF.format(singleDate.getDate());
        }

        public String format(VerbatimTimePeriod verbatimTimePeriod) {
            return "";
        }
    }

    public static class DcDatasetWrapper {
        private final Dataset dataset;
        private final ContactAdapter contactAdapter;
        private final Map<String, Object> additionalProperties;

        public DcDatasetWrapper(Dataset dataset) {
            this(dataset, null);
        }

        public DcDatasetWrapper(Dataset dataset, Map<String, Object> additionalProperties) {
            this.dataset = dataset;
            this.contactAdapter = new ContactAdapter(dataset.getContacts());
            this.additionalProperties = additionalProperties;
        }

        public String getFormat() {
            if (this.additionalProperties != null && this.additionalProperties.containsKey(DublinCoreWriter.ADDITIONAL_PROPERTY_DC_FORMAT)) {
                return (String)this.additionalProperties.get(DublinCoreWriter.ADDITIONAL_PROPERTY_DC_FORMAT);
            }
            return "";
        }

        public Set<String> getCreators() {
            LinkedHashSet<String> creators = Sets.newLinkedHashSet();
            List<Contact> filteredContacts = this.contactAdapter.getFilteredContacts(ContactType.ADMINISTRATIVE_POINT_OF_CONTACT, ContactType.METADATA_AUTHOR, ContactType.ORIGINATOR);
            for (Contact contact : filteredContacts) {
                creators.add(ContactAdapter.formatContactName(contact));
            }
            return creators;
        }

        public List<String> getDescription() {
            ArrayList<String> descriptions = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)this.dataset.getDescription())) {
                descriptions.add(this.dataset.getDescription());
            }
            return descriptions;
        }

        public Long getOccurrenceCount() {
            if (this.additionalProperties != null && this.additionalProperties.containsKey(DublinCoreWriter.ADDITIONAL_PROPERTY_OCC_COUNT)) {
                return (Long)this.additionalProperties.get(DublinCoreWriter.ADDITIONAL_PROPERTY_OCC_COUNT);
            }
            return null;
        }

        public List<String> getFormattedTemporalCoverage() {
            ArrayList<String> coverage = Lists.newArrayList();
            if (this.dataset.getTemporalCoverages() != null) {
                for (TemporalCoverage tc : this.dataset.getTemporalCoverages()) {
                    coverage.add(tc.acceptFormatter(TC_FORMATTER));
                }
            }
            return coverage;
        }

        public String getIdentifier() {
            return DublinCoreWriter.IDENTIFIER_PREFIX + this.dataset.getKey().toString();
        }

        public Contact getResourceCreator() {
            return this.contactAdapter.getResourceCreator();
        }
    }
}

