/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Endpoint;
import org.gbif.api.model.registry.Metadata;
import org.gbif.api.model.registry.Network;
import org.gbif.api.service.registry.DatasetService;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetType;
import org.gbif.api.vocabulary.EndpointType;
import org.gbif.api.vocabulary.MetadataType;
import org.gbif.checklistbank.registry.EmptyNetworkEntityService;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetServiceFileImpl
extends EmptyNetworkEntityService<Dataset>
implements DatasetService {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetServiceFileImpl.class);
    private final TreeMap<UUID, Dataset> datasets = Maps.newTreeMap();

    public DatasetServiceFileImpl(File dataFile) {
        try (FileInputStream in = new FileInputStream(dataFile);){
            CSVReader reader = CSVReaderFactory.buildUtf8TabReader((InputStream)in);
            int endKey = 1;
            while (reader.hasNext()) {
                String[] row = reader.next();
                if (row == null || row.length < 3 || row[0].startsWith("#")) continue;
                Dataset d = new Dataset();
                d.setType(DatasetType.CHECKLIST);
                d.setKey(UUID.fromString(row[0].trim()));
                d.setTitle(row[1].trim());
                Endpoint end = new Endpoint();
                end.setKey(Integer.valueOf(endKey++));
                end.setType(EndpointType.DWC_ARCHIVE);
                end.setUrl(URI.create(row[2].trim()));
                d.getEndpoints().add(end);
                this.datasets.put(d.getKey(), d);
            }
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        LOG.info("Loaded {} datasets into registry from {}", (Object)this.datasets.size(), (Object)dataFile.getAbsolutePath());
    }

    @Override
    public Dataset get(@NotNull UUID key) {
        return this.datasets.get(key);
    }

    @Override
    public Map<UUID, String> getTitles(Collection<UUID> keys) {
        return this.datasets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Dataset)e.getValue()).getTitle()));
    }

    @Override
    public PagingResponse<Dataset> list(@Nullable Pageable page) {
        if (page == null) {
            page = new PagingResponse();
        }
        PagingResponse resp = new PagingResponse();
        int idx = 1;
        for (Map.Entry<UUID, Dataset> e : this.datasets.entrySet()) {
            if ((long)idx >= page.getOffset()) {
                if (idx >= page.getLimit()) break;
                resp.getResults().add(e.getValue());
            }
            ++idx;
        }
        resp.setCount(Long.valueOf(this.datasets.size()));
        return resp;
    }

    public PagingResponse<Dataset> listConstituents(UUID datasetKey, @Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listConstituents(@Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listByCountry(Country country, @Nullable DatasetType type, @Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listByType(DatasetType type, @Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public List<Metadata> listMetadata(UUID datasetKey, @Nullable MetadataType type) {
        throw new UnsupportedOperationException();
    }

    public List<Network> listNetworks(UUID datasetKey) {
        throw new UnsupportedOperationException();
    }

    public Metadata getMetadata(int metadataKey) {
        throw new UnsupportedOperationException();
    }

    public void deleteMetadata(int metadataKey) {
        throw new UnsupportedOperationException();
    }

    public Metadata insertMetadata(UUID datasetKey, InputStream document) {
        throw new UnsupportedOperationException();
    }

    public InputStream getMetadataDocument(UUID datasetKey) {
        throw new UnsupportedOperationException();
    }

    public InputStream getMetadataDocument(int metadataKey) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listDeleted(@Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listDuplicates(@Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listDatasetsWithNoEndpoint(@Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }

    public PagingResponse<Dataset> listByDOI(String doi, @Nullable Pageable page) {
        throw new UnsupportedOperationException();
    }
}

