/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.config;

import com.beust.jcommander.ParametersDelegate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.gbif.checklistbank.registry.FileRegistryModule;
import org.gbif.registry.ws.client.guice.RegistryWsClientModule;
import org.gbif.ws.client.guice.AnonymousAuthModule;
import org.gbif.ws.client.guice.SingleUserAuthModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryServiceConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryServiceConfiguration.class);
    @ParametersDelegate
    @Valid
    @NotNull
    public String wsUrl = "http://api.gbif.org/v1";
    public String user;
    public String password;

    public Injector createRegistryInjector(Module ... otherModules) {
        ArrayList<Module> modules = Lists.newArrayList(otherModules);
        modules.addAll(this.guiceModules());
        Injector injClient = Guice.createInjector(modules);
        return injClient;
    }

    public List<Module> guiceModules() {
        if (this.wsUrl.startsWith("http")) {
            LOG.info("Connecting to registry services at {}", (Object)this.wsUrl);
            Properties props = new Properties();
            props.put("registry.ws.url", this.wsUrl);
            ArrayList<Module> modules = Lists.newArrayList();
            if (!Strings.isNullOrEmpty(this.user) && !Strings.isNullOrEmpty(this.password)) {
                modules.add((Module)new SingleUserAuthModule(this.user, this.password));
            } else {
                modules.add((Module)new AnonymousAuthModule());
            }
            modules.add((Module)new RegistryWsClientModule(props));
            return modules;
        }
        LOG.info("Loading registry datasets from {}", (Object)this.wsUrl);
        return Lists.newArrayList(new Module[]{new FileRegistryModule(new File(this.wsUrl))});
    }
}

