/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.config;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Properties;
import org.gbif.checklistbank.config.GangliaConfiguration;
import org.gbif.checklistbank.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(MetricModule.class);
    private final GangliaConfiguration cfg;

    public MetricModule(Properties properties) {
        this.cfg = new GangliaConfiguration();
        this.cfg.host = properties.getProperty("ganglia.host");
        this.cfg.port = PropertiesUtils.getIntProp(properties, "ganglia.host", this.cfg.port);
    }

    public MetricModule(GangliaConfiguration cfg) {
        this.cfg = cfg;
    }

    @Provides
    @Singleton
    public GangliaConfiguration provideCfg() throws Exception {
        return this.cfg;
    }

    @Provides
    @Singleton
    @Inject
    public MetricRegistry provideMetricRegistry(GangliaConfiguration cfg) throws Exception {
        MetricRegistry reg = new MetricRegistry();
        cfg.start(reg);
        return reg;
    }

    protected void configure() {
    }
}

