/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.authorship;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.checklistbank.model.Equality;

public class YearComparator {
    private static final Pattern YEAR = Pattern.compile("(^|[^0-9])([0-9?]{4})([^0-9]|$)");
    private String y1;
    private String y2;

    public YearComparator(String y1, String y2) {
        this.y1 = this.normalizeYear(y1);
        this.y2 = this.normalizeYear(y2);
    }

    private String normalizeYear(String y) {
        if (y == null) {
            return null;
        }
        Matcher m = YEAR.matcher(StringUtils.deleteWhitespace((String)y));
        if (m.find()) {
            return m.group(2);
        }
        return AuthorComparator.normalize(y);
    }

    private boolean replacePlaceholders() {
        int qm1 = this.y1.indexOf(63);
        int qm2 = this.y2.indexOf(63);
        if (qm1 >= 0 || qm2 >= 0) {
            StringBuilder s1 = new StringBuilder(this.y1);
            StringBuilder s2 = new StringBuilder(this.y2);
            if (qm1 >= 0) {
                s1.setCharAt(qm1, '_');
                if (s2.length() > qm1) {
                    s2.setCharAt(qm1, '_');
                }
            }
            if (qm2 >= 0) {
                if (s1.length() > qm2) {
                    s1.setCharAt(qm2, '_');
                }
                s2.setCharAt(qm2, '_');
            }
            this.y1 = s1.toString();
            this.y2 = s2.toString();
            return true;
        }
        return false;
    }

    public Equality compare() {
        if (this.y1 != null && this.y2 != null) {
            block5: {
                if (this.y1.equals(this.y2)) {
                    return Equality.EQUAL;
                }
                try {
                    int yi1 = Integer.parseInt(this.y1);
                    int yi2 = Integer.parseInt(this.y2);
                    if (Math.abs(yi1 - yi2) <= 1) {
                        return Equality.EQUAL;
                    }
                }
                catch (NumberFormatException e) {
                    if (!this.replacePlaceholders() || !this.y1.equals(this.y2)) break block5;
                    return Equality.EQUAL;
                }
            }
            return Equality.DIFFERENT;
        }
        return Equality.UNKNOWN;
    }
}

