/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.authorship;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.checklistbank.authorship.AuthorComparator;
import org.gbif.checklistbank.authorship.BasionymGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasionymSorter {
    private static final Logger LOG = LoggerFactory.getLogger(BasionymSorter.class);
    private AuthorComparator authorComp;

    public BasionymSorter() {
        this.authorComp = AuthorComparator.createWithAuthormap();
    }

    public BasionymSorter(AuthorComparator authorComp) {
        this.authorComp = authorComp;
    }

    public Collection<BasionymGroup<ParsedName>> groupBasionyms(Iterable<ParsedName> names) {
        return this.groupBasionyms(names, Functions.identity());
    }

    private <T> BasionymGroup<T> findExistingGroup(T p, List<BasionymGroup<T>> groups, Function<T, ParsedName> func) {
        ParsedName pn = func.apply(p);
        for (BasionymGroup<T> g : groups) {
            ParsedName representative = func.apply(g.getRecombinations().get(0));
            if (!this.authorComp.compareStrict(pn.getBracketAuthorship(), pn.getBracketYear(), representative.getBracketAuthorship(), representative.getBracketYear())) continue;
            return g;
        }
        return null;
    }

    private <T> T findBasionym(String authorship, String year, List<T> originals, Function<T, ParsedName> func) throws MultipleBasionymException {
        ParsedName b;
        ArrayList<T> basionyms = Lists.newArrayList();
        for (T obj : originals) {
            b = func.apply(obj);
            if (!this.authorComp.compareStrict(authorship, year, b.getAuthorship(), b.getYear())) continue;
            basionyms.add(obj);
        }
        if (basionyms.isEmpty() && authorship != null) {
            for (T obj : originals) {
                b = func.apply(obj);
                if (!this.authorComp.compareStrict(authorship, null, b.getAuthorship(), null)) continue;
                basionyms.add(obj);
            }
        }
        if (basionyms.size() == 1) {
            return (T)basionyms.get(0);
        }
        if (basionyms.isEmpty()) {
            return null;
        }
        throw new MultipleBasionymException();
    }

    public <T> Collection<BasionymGroup<T>> groupBasionyms(Iterable<T> names, Function<T, ParsedName> func) {
        ArrayList<BasionymGroup<T>> groups = Lists.newArrayList();
        ArrayList<Object> recombinations = Lists.newArrayList();
        ArrayList<T> originals = Lists.newArrayList();
        for (T obj : names) {
            ParsedName p = func.apply(obj);
            if (p != null) {
                if (p.isRecombination()) {
                    recombinations.add(obj);
                    continue;
                }
                if (p.getAuthorship() == null && p.getYear() == null) continue;
                originals.add(obj);
                continue;
            }
            LOG.warn("No parsed name returned for name object {}", obj);
        }
        for (Object recomb : recombinations) {
            BasionymGroup<Object> group = this.findExistingGroup(recomb, groups, func);
            if (group == null) {
                ParsedName pn = func.apply(recomb);
                if (pn != null) {
                    group = new BasionymGroup();
                    group.setName(pn.getTerminalEpithet(), pn.getBracketAuthorship(), pn.getBracketYear());
                    groups.add(group);
                    group.getRecombinations().add(recomb);
                    continue;
                }
                LOG.warn("No parsed name returned for name recombination {}", recomb);
                continue;
            }
            group.getRecombinations().add(recomb);
        }
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            BasionymGroup group = (BasionymGroup)iter.next();
            try {
                group.setBasionym(this.findBasionym(group.getAuthorship(), group.getYear(), originals, func));
            }
            catch (MultipleBasionymException e) {
                LOG.info("Ignore group with multiple basionyms found for {} {} {} in {} original names", new Object[]{group.getEpithet(), group.getAuthorship(), group.getYear(), originals.size()});
                iter.remove();
            }
        }
        return groups;
    }

    public static class MultipleBasionymException
    extends Exception {
    }
}

