/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.varnish;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.gbif.varnish.HttpBan;
import org.gbif.varnish.HttpPurge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarnishPurger {
    private static final Logger LOG = LoggerFactory.getLogger(VarnishPurger.class);
    private final CloseableHttpClient client;
    private final URI apiBaseUrl;
    private final String apiBaseUrlStr;
    private final String apiPath;
    private static final Joiner PATH_JOINER = Joiner.on((String)"/").skipNulls();
    private static final Joiner PIPE_JOINER = Joiner.on((String)"|").skipNulls();

    public VarnishPurger(CloseableHttpClient client, URI apiBaseUrl) {
        Preconditions.checkArgument((boolean)apiBaseUrl.isAbsolute(), (Object)"apiBaseUrl must be absolute");
        this.client = client;
        this.apiBaseUrl = apiBaseUrl;
        this.apiBaseUrlStr = StringUtils.removeEnd(apiBaseUrl.toString(), "/");
        this.apiPath = StringUtils.removeEnd(apiBaseUrl.getPath(), "/");
    }

    public static String anyKey(Set<?> keys) {
        if (keys.size() == 1) {
            return keys.iterator().next().toString();
        }
        return "(" + PIPE_JOINER.join(keys) + ")";
    }

    public static String path(String ... parts) {
        return PATH_JOINER.join((Object[])parts);
    }

    public void purge(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path can not be null");
        URI uri = URI.create(String.format("%s/%s", this.apiBaseUrlStr, StringUtils.removeStart(path, "/")));
        try {
            CloseableHttpResponse resp = this.client.execute((HttpUriRequest)new HttpPurge(uri));
            resp.close();
        }
        catch (IOException e) {
            LOG.error("Failed to purge {}", (Object)uri, (Object)e);
        }
    }

    public void ban(String regex) {
        Preconditions.checkNotNull((Object)regex, (Object)"regex can not be null");
        regex = String.format("%s/%s", this.apiPath, StringUtils.removeStart(regex, "/"));
        try {
            CloseableHttpResponse resp = this.client.execute((HttpUriRequest)new HttpBan(this.apiBaseUrl, regex));
            resp.close();
        }
        catch (IOException e) {
            LOG.error("Failed to ban {}", (Object)regex, (Object)e);
        }
    }
}

