/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveAuthenticationInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PreemptiveAuthenticationInterceptor.class);

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScope authScope;
        Credentials creds;
        LOG.debug(request.getRequestLine().toString());
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (authState.getAuthScheme() == null && credsProvider != null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
            LOG.debug("Authentication used for scope " + authScope.getHost());
            authState.setAuthScheme((AuthScheme)new BasicScheme());
            authState.setCredentials(creds);
        }
    }
}

