/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtil.class);
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String MODIFIED_SINCE = "If-Modified-Since";
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String UTF_8 = "UTF-8";
    private final CloseableHttpClient client;

    public HttpUtil(CloseableHttpClient client) {
        this.client = client;
    }

    public static UsernamePasswordCredentials credentials(String username, String password) {
        return new UsernamePasswordCredentials(StringUtils.trimToEmpty(username), StringUtils.trimToEmpty(password));
    }

    public static HttpEntity map2Entity(Map<String, String> kvp) {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>(kvp.size());
        for (Map.Entry<String, String> entry : kvp.entrySet()) {
            formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            return new UrlEncodedFormEntity(formparams, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Can't encode post entity with utf8", (Throwable)e);
            return null;
        }
    }

    public static HttpEntity map2Entity(String key, String data) {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>(1);
        formparams.add(new BasicNameValuePair(key, data));
        try {
            return new UrlEncodedFormEntity(formparams, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Can't encode post entity with utf8", (Throwable)e);
            return null;
        }
    }

    public static DefaultHttpClient newMultithreadedClient(int timeout, int maxConnections, int maxPerRoute) {
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.protocol.content-charset", (Object)UTF_8);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeout);
        params.setLongParameter("http.conn-manager.timeout", (long)timeout);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme(HTTP_PROTOCOL, 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme(HTTPS_PROTOCOL, 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        return new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
    }

    public static Date parseHeaderDate(String rfcDate) {
        try {
            if (rfcDate != null) {
                return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US).parse(rfcDate);
            }
        }
        catch (ParseException e) {
            LOG.debug("Can't parse RFC2616 date");
        }
        return null;
    }

    public static String responseAsString(HttpResponse response) {
        String content = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                content = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (org.apache.http.ParseException e) {
                LOG.error("ParseException consuming http response into string", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("IOException consuming http response into string", (Throwable)e);
            }
        }
        return content;
    }

    public static HttpEntity stringEntity(String data) throws UnsupportedEncodingException {
        return new StringEntity(data, UTF_8);
    }

    public static boolean success(Response resp) {
        return resp != null && HttpUtil.success(resp.getStatusLine());
    }

    public static boolean success(StatusLine status) {
        return status != null && status.getStatusCode() >= 200 && status.getStatusCode() < 300;
    }

    private HttpContext buildContext(String uri, UsernamePasswordCredentials credentials) throws URISyntaxException {
        BasicHttpContext authContext = new BasicHttpContext();
        if (credentials != null) {
            URI authUri = new URI(uri);
            AuthScope scope = new AuthScope(authUri.getHost(), -1, AuthScope.ANY_REALM);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(scope, (Credentials)credentials);
            authContext.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
        }
        return authContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(String url, UsernamePasswordCredentials credentials) throws IOException, URISyntaxException {
        LOG.info("Http delete to {}", (Object)url);
        HttpDelete delete = new HttpDelete(url);
        HttpContext authContext = this.buildContext(url, credentials);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)delete, authContext);
        Response result = new Response((HttpResponse)response);
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result.content = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        finally {
            this.closeQuietly(response);
        }
        return result;
    }

    public StatusLine download(String url, File downloadTo) throws IOException {
        return this.download(new URL(url), downloadTo);
    }

    public StatusLine download(URI url, File downloadTo) throws IOException {
        return this.download(url.toURL(), downloadTo);
    }

    public String download(URL url) throws IOException {
        try {
            Response resp = this.get(url.toString());
            return resp.content;
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid URL provided: {}", (Object)url, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine download(URL url, File downloadTo) throws IOException {
        HttpGet get = new HttpGet(url.toString());
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
        StatusLine status = response.getStatusLine();
        try {
            if (HttpUtil.success(status)) {
                this.saveToFile(response, downloadTo);
                LOG.debug("Successfully downloaded {} to {}", (Object)url, (Object)downloadTo.getAbsolutePath());
            } else {
                LOG.error("Downloading {} to {} failed!: {}", new Object[]{url, downloadTo.getAbsolutePath(), status.getStatusCode()});
            }
        }
        finally {
            this.closeQuietly(response);
        }
        return status;
    }

    public String downloadIfChanged(URL url, Date lastModified) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put(MODIFIED_SINCE, DateFormatUtils.SMTP_DATETIME_FORMAT.format(lastModified));
        try {
            Response resp = this.get(url.toString(), header, null);
            if (resp.getStatusCode() == 304) {
                LOG.debug("Content not modified since last request");
            }
            return resp.content;
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid URL provided: {}", (Object)url, (Object)e);
            return null;
        }
    }

    public boolean downloadIfChanged(URL url, Date lastModified, File downloadTo) throws IOException {
        StatusLine status = this.downloadIfModifiedSince(url, lastModified, downloadTo);
        return HttpUtil.success(status);
    }

    public boolean downloadIfChanged(URL url, File downloadTo) throws IOException {
        StatusLine status = this.downloadIfModifiedSince(url, downloadTo);
        return HttpUtil.success(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine downloadIfModifiedSince(URL url, Date lastModified, File downloadTo) throws IOException {
        HttpGet get = new HttpGet(url.toString());
        if (lastModified != null) {
            get.addHeader(MODIFIED_SINCE, DateFormatUtils.SMTP_DATETIME_FORMAT.format(lastModified));
            LOG.debug("Conditional GET: {}", (Object)DateFormatUtils.SMTP_DATETIME_FORMAT.format(lastModified));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
        StatusLine status = response.getStatusLine();
        try {
            if (status.getStatusCode() == 304) {
                LOG.debug("Content not modified since last request");
            } else if (HttpUtil.success(status)) {
                this.saveToFile(response, downloadTo);
                LOG.debug("Successfully downloaded {} to {}", (Object)url, (Object)downloadTo.getAbsolutePath());
            } else {
                LOG.error("Downloading {} to {} failed!: {}", new Object[]{url, downloadTo.getAbsolutePath(), status.getStatusCode()});
            }
        }
        finally {
            this.closeQuietly(response);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(CloseableHttpResponse response, File downloadTo) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            Date serverModified = null;
            Header modHeader = response.getFirstHeader(LAST_MODIFIED);
            if (modHeader != null) {
                serverModified = HttpUtil.parseHeaderDate(modHeader.getValue());
            }
            FileUtils.forceMkdir(downloadTo.getParentFile());
            FileOutputStream fos = new FileOutputStream(downloadTo, false);
            try {
                entity.writeTo((OutputStream)fos);
            }
            finally {
                ((OutputStream)fos).close();
            }
            if (serverModified != null) {
                downloadTo.setLastModified(serverModified.getTime());
            }
        }
    }

    public StatusLine downloadIfModifiedSince(URL url, File downloadTo) throws IOException {
        Date lastModified = null;
        if (downloadTo.exists()) {
            lastModified = new Date(downloadTo.lastModified());
        }
        return this.downloadIfModifiedSince(url, lastModified, downloadTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpResponse executeGetWithTimeout(HttpGet get, int timeout) throws IOException {
        HttpParams httpParams = this.client.getParams();
        int ct = HttpConnectionParams.getConnectionTimeout((HttpParams)httpParams);
        int st = HttpConnectionParams.getSoTimeout((HttpParams)httpParams);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)get);
        }
        finally {
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)ct);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)st);
        }
        return response;
    }

    public Response get(String url) throws IOException, URISyntaxException {
        return this.get(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response get(String url, Map<String, String> headers, UsernamePasswordCredentials credentials) throws IOException, URISyntaxException {
        HttpGet get = new HttpGet(url);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                get.addHeader(StringUtils.trimToEmpty(header.getKey()), StringUtils.trimToEmpty(header.getValue()));
            }
        }
        HttpContext authContext = this.buildContext(url, credentials);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)get, authContext);
        Response result = new Response((HttpResponse)response);
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result.content = EntityUtils.toString((HttpEntity)entity, (String)UTF_8);
            }
        }
        finally {
            this.closeQuietly(response);
        }
        return result;
    }

    @Deprecated
    public HttpParams params(Map<String, Object> params) {
        BasicHttpParams p = new BasicHttpParams();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            p.setParameter(param.getKey(), param.getValue());
        }
        return p;
    }

    public Response post(String uri, HttpEntity requestEntity) throws IOException, URISyntaxException {
        return this.post(uri, null, null, requestEntity);
    }

    public Response post(String uri, UsernamePasswordCredentials credentials, HttpEntity requestEntity) throws IOException, URISyntaxException {
        return this.post(uri, null, credentials, requestEntity);
    }

    public Response post(String uri, Map<String, String> headers, UsernamePasswordCredentials credentials) throws IOException, URISyntaxException {
        return this.post(uri, headers, credentials, null);
    }

    public Response post(String uri, Map<String, String> headers, UsernamePasswordCredentials credentials, HttpEntity requestEntity) throws IOException, URISyntaxException {
        HttpContext authContext;
        CloseableHttpResponse response;
        HttpPost post = new HttpPost(uri);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                post.addHeader(StringUtils.trimToEmpty(header.getKey()), StringUtils.trimToEmpty(header.getValue()));
            }
        }
        if (requestEntity != null) {
            post.setEntity(requestEntity);
        }
        if ((response = this.client.execute((HttpUriRequest)post, authContext = this.buildContext(uri, credentials))) != null) {
            Response result = new Response((HttpResponse)response);
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                result.content = EntityUtils.toString((HttpEntity)respEntity);
                EntityUtils.consume((HttpEntity)respEntity);
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public Response post(String uri, HttpParams params, Map<String, String> headers, UsernamePasswordCredentials credentials) throws IOException, URISyntaxException {
        return this.post(uri, params, headers, credentials, null);
    }

    @Deprecated
    public Response post(String uri, HttpParams params, Map<String, String> headers, UsernamePasswordCredentials credentials, HttpEntity encodedEntity) throws IOException, URISyntaxException {
        return this.post(uri, headers, credentials, encodedEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyHost(HttpHost host) {
        if (host != null) {
            CloseableHttpResponse resp = null;
            try {
                HttpHead head = new HttpHead(host.toURI());
                resp = this.client.execute(host, (HttpRequest)head);
                boolean bl = true;
                this.closeQuietly(resp);
                return bl;
            }
            catch (Exception e) {
                LOG.debug("Exception thrown", (Throwable)e);
            }
            finally {
                this.closeQuietly(resp);
            }
        }
        return false;
    }

    private void closeQuietly(CloseableHttpResponse resp) {
        if (resp != null) {
            try {
                resp.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close http response", (Throwable)e);
            }
        }
    }

    public static class Response {
        public String content;
        private final HttpResponse response;

        public Response(HttpResponse resp) {
            this.response = resp;
        }

        public boolean containsHeader(String name) {
            return this.response.containsHeader(name);
        }

        public Header[] getAllHeaders() {
            return this.response.getAllHeaders();
        }

        public Header getFirstHeader(String name) {
            return this.response.getFirstHeader(name);
        }

        public Header[] getHeaders(String name) {
            return this.response.getHeaders(name);
        }

        public Header getLastHeader(String name) {
            return this.response.getLastHeader(name);
        }

        public Locale getLocale() {
            return this.response.getLocale();
        }

        @Deprecated
        public HttpParams getParams() {
            return this.response.getParams();
        }

        public ProtocolVersion getProtocolVersion() {
            return this.response.getProtocolVersion();
        }

        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public StatusLine getStatusLine() {
            return this.response.getStatusLine();
        }

        public HeaderIterator headerIterator() {
            return this.response.headerIterator();
        }

        public HeaderIterator headerIterator(String name) {
            return this.response.headerIterator(name);
        }
    }
}

