/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.occurrence.query;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.gbif.occurrence.query.TitleLookup;
import org.gbif.utils.HttpUtil;
import org.gbif.ws.json.JacksonJsonContextResolver;
import org.gbif.ws.mixin.Mixins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleLookupModule
extends PrivateModule {
    private static final Logger LOG = LoggerFactory.getLogger(TitleLookupModule.class);
    private final boolean provideHttpClient;
    private final URI apiRoot;

    public TitleLookupModule(boolean provideHttpClient, String apiRoot) {
        this.provideHttpClient = provideHttpClient;
        this.apiRoot = URI.create((String)Preconditions.checkNotNull((Object)apiRoot, (Object)"API url can't be null"));
        Preconditions.checkArgument((this.apiRoot.getHost() != null ? 1 : 0) != 0, (Object)("API url must have a host! " + apiRoot));
        LOG.info("Create new TitleLookup using API " + apiRoot);
    }

    protected void configure() {
        if (this.provideHttpClient) {
            this.bind(HttpClient.class).toInstance((Object)TitleLookupModule.provideHttpClient());
        }
        this.expose(TitleLookup.class);
    }

    @Provides
    @Singleton
    @Inject
    public TitleLookup provideLookup(HttpClient hc) {
        ApacheHttpClient4Handler hch = new ApacheHttpClient4Handler(hc, null, false);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonContextResolver.class);
        JacksonJsonContextResolver.addMixIns((Map)Mixins.getPredefinedMixins());
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        WebResource api = new ApacheHttpClient4(hch, (ClientConfig)clientConfig).resource(this.apiRoot);
        return new TitleLookup(api);
    }

    private static HttpClient provideHttpClient() {
        return HttpUtil.newMultithreadedClient((int)5000, (int)10, (int)10);
    }
}

