/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.occurrence.query;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.gbif.api.model.checklistbank.NameUsage;
import org.gbif.api.model.registry.Dataset;
import org.gbif.utils.HttpUtil;
import org.gbif.ws.client.guice.GbifWsClientModule;
import org.gbif.ws.json.JacksonJsonContextResolver;
import org.gbif.ws.mixin.LicenseMixin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleLookup {
    private static final int HTTP_TIME_OUT = 2000;
    private static final Logger LOG = LoggerFactory.getLogger(TitleLookup.class);
    private final WebResource apiRoot;

    public TitleLookup(String apiRootUrl, int threads) {
        this.apiRoot = GbifWsClientModule.buildJerseyClient((HttpClient)HttpUtil.newMultithreadedClient((int)2000, (int)threads, (int)threads)).resource(apiRootUrl);
    }

    public TitleLookup(WebResource apiRoot) {
        this.apiRoot = apiRoot;
    }

    public String getDatasetTitle(String datasetKey) {
        try {
            JacksonJsonContextResolver.addMixIns((Map)new ImmutableMap.Builder().put(Dataset.class, LicenseMixin.class).build());
            return ((Dataset)this.apiRoot.path("dataset").path(datasetKey).get(Dataset.class)).getTitle();
        }
        catch (RuntimeException e) {
            LOG.error("Cannot lookup dataset title {}", (Object)datasetKey, (Object)e);
            return datasetKey;
        }
    }

    public String getSpeciesName(String usageKey) {
        try {
            return ((NameUsage)this.apiRoot.path("species").path(usageKey).get(NameUsage.class)).getScientificName();
        }
        catch (RuntimeException e) {
            LOG.error("Cannot lookup species title {}", (Object)usageKey, (Object)e);
            return usageKey;
        }
    }
}

