/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.occurrence.query;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gbif.api.model.occurrence.predicate.ConjunctionPredicate;
import org.gbif.api.model.occurrence.predicate.DisjunctionPredicate;
import org.gbif.api.model.occurrence.predicate.EqualsPredicate;
import org.gbif.api.model.occurrence.predicate.GreaterThanOrEqualsPredicate;
import org.gbif.api.model.occurrence.predicate.GreaterThanPredicate;
import org.gbif.api.model.occurrence.predicate.InPredicate;
import org.gbif.api.model.occurrence.predicate.IsNotNullPredicate;
import org.gbif.api.model.occurrence.predicate.LessThanOrEqualsPredicate;
import org.gbif.api.model.occurrence.predicate.LessThanPredicate;
import org.gbif.api.model.occurrence.predicate.LikePredicate;
import org.gbif.api.model.occurrence.predicate.NotPredicate;
import org.gbif.api.model.occurrence.predicate.Predicate;
import org.gbif.api.model.occurrence.predicate.WithinPredicate;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParameterFilterBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(QueryParameterFilterBuilder.class);
    private static final String WILDCARD = "*";
    private static final Pattern POLYGON_PATTERN = Pattern.compile("POLYGON\\s*\\(\\s*\\((.+)\\)\\s*\\)", 2);
    private Map<OccurrenceSearchParameter, LinkedList<String>> filter;
    private State state;
    private OccurrenceSearchParameter lastParam;

    public synchronized String queryFilter(Predicate p) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        this.filter = Maps.newHashMap();
        this.state = State.ROOT;
        this.lastParam = null;
        this.visit(p);
        for (Map.Entry<OccurrenceSearchParameter, LinkedList<String>> entry : this.filter.entrySet()) {
            for (String val : entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    b.append("&");
                }
                b.append(entry.getKey().name());
                b.append("=");
                b.append(URLEncoder.encode(val));
            }
        }
        return b.toString();
    }

    private void visit(ConjunctionPredicate and) throws IllegalStateException {
        try {
            this.visitRange(and);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.state != State.ROOT) {
                throw new IllegalStateException("AND must be a root predicate or a valid range");
            }
            this.state = State.AND;
            for (Predicate p : and.getPredicates()) {
                this.lastParam = null;
                this.visit(p);
            }
            this.state = State.ROOT;
            return;
        }
    }

    private void visitRange(ConjunctionPredicate and) {
        if (and.getPredicates().size() != 2) {
            throw new IllegalArgumentException("no valid range");
        }
        GreaterThanOrEqualsPredicate lower = null;
        LessThanOrEqualsPredicate upper = null;
        for (Predicate p : and.getPredicates()) {
            if (p instanceof GreaterThanOrEqualsPredicate) {
                lower = (GreaterThanOrEqualsPredicate)p;
                continue;
            }
            if (!(p instanceof LessThanOrEqualsPredicate)) continue;
            upper = (LessThanOrEqualsPredicate)p;
        }
        if (lower == null || upper == null || lower.getKey() != upper.getKey()) {
            throw new IllegalArgumentException("no valid range");
        }
        this.addQueryParam(lower.getKey(), this.range(lower.getValue(), upper.getValue()));
    }

    private String range(String from, String to) {
        if (Strings.isNullOrEmpty((String)from)) {
            from = WILDCARD;
        }
        if (Strings.isNullOrEmpty((String)to)) {
            to = WILDCARD;
        }
        return from + "," + to;
    }

    private void visit(DisjunctionPredicate or) throws IllegalStateException {
        State oldState = this.state;
        if (this.state == State.OR) {
            throw new IllegalStateException("OR within OR filters not supported");
        }
        this.state = State.OR;
        for (Predicate p : or.getPredicates()) {
            this.visit(p);
        }
        this.state = oldState;
    }

    private void visit(EqualsPredicate predicate) {
        this.addQueryParam(predicate.getKey(), predicate.getValue());
    }

    private void visit(IsNotNullPredicate predicate) {
        this.addQueryParam(predicate.getParameter(), WILDCARD);
    }

    private void visit(LikePredicate predicate) {
        throw new IllegalArgumentException("LIKE operator not supported in web queries");
    }

    private void visit(GreaterThanPredicate predicate) {
        throw new IllegalArgumentException("GREATER_THAN_OPERATOR operator not supported in web queries");
    }

    private void visit(GreaterThanOrEqualsPredicate p) {
        this.addQueryParam(p.getKey(), this.range(p.getValue(), null));
    }

    private void visit(LessThanPredicate predicate) {
        throw new IllegalArgumentException("LESS_THAN_OPERATOR operator not supported in web queries");
    }

    private void visit(LessThanOrEqualsPredicate p) {
        this.addQueryParam(p.getKey(), this.range(null, p.getValue()));
    }

    private void visit(WithinPredicate within) {
        this.addQueryParam(OccurrenceSearchParameter.GEOMETRY, this.extractPolygonValues(within.getGeometry()));
    }

    private String extractPolygonValues(String withinValue) {
        Matcher m = POLYGON_PATTERN.matcher(withinValue);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("No valid polygon WKT: " + withinValue);
    }

    private void visit(InPredicate in) {
        for (String val : in.getValues()) {
            this.addQueryParam(in.getKey(), val);
        }
    }

    private void visit(NotPredicate not) throws IllegalStateException {
        throw new IllegalArgumentException("NOT operator not supported in web queries");
    }

    private void addQueryParam(OccurrenceSearchParameter param, String value) {
        if (this.lastParam != null && param != this.lastParam) {
            throw new IllegalArgumentException("Mix of search params not supported");
        }
        if (!this.filter.containsKey(param)) {
            this.filter.put(param, Lists.newLinkedList());
        }
        this.filter.get(param).add(value);
        this.lastParam = param;
    }

    private void visit(Predicate p) throws IllegalStateException {
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("visit", p.getClass());
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Visit method could not be found. That means a Predicate has been passed in that is unknown to this class", (Throwable)e);
            throw new IllegalArgumentException("Unknown Predicate", e);
        }
        try {
            method.setAccessible(true);
            method.invoke((Object)this, p);
        }
        catch (IllegalAccessException e) {
            LOG.error("This should never happen as we set accessible to true explicitly before. Probably a programming error", (Throwable)e);
            throw new RuntimeException("Programming error", e);
        }
        catch (InvocationTargetException e) {
            LOG.info("Exception thrown while building the Hive Download", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private static enum State {
        ROOT,
        AND,
        OR;

    }
}

