/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.occurrence.query;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import org.gbif.api.model.occurrence.predicate.ConjunctionPredicate;
import org.gbif.api.model.occurrence.predicate.DisjunctionPredicate;
import org.gbif.api.model.occurrence.predicate.EqualsPredicate;
import org.gbif.api.model.occurrence.predicate.GreaterThanOrEqualsPredicate;
import org.gbif.api.model.occurrence.predicate.GreaterThanPredicate;
import org.gbif.api.model.occurrence.predicate.InPredicate;
import org.gbif.api.model.occurrence.predicate.IsNotNullPredicate;
import org.gbif.api.model.occurrence.predicate.LessThanOrEqualsPredicate;
import org.gbif.api.model.occurrence.predicate.LessThanPredicate;
import org.gbif.api.model.occurrence.predicate.LikePredicate;
import org.gbif.api.model.occurrence.predicate.NotPredicate;
import org.gbif.api.model.occurrence.predicate.Predicate;
import org.gbif.api.model.occurrence.predicate.SimplePredicate;
import org.gbif.api.model.occurrence.predicate.WithinPredicate;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;
import org.gbif.api.util.VocabularyUtils;
import org.gbif.api.vocabulary.Continent;
import org.gbif.api.vocabulary.Country;
import org.gbif.occurrence.query.TitleLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanFilterBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HumanFilterBuilder.class);
    private static final String DEFAULT_BUNDLE = "org/gbif/occurrence/query/filter";
    private static final String EQUALS_OPERATOR = "";
    private static final String GREATER_THAN_OPERATOR = "> ";
    private static final String GREATER_THAN_EQUALS_OPERATOR = ">= ";
    private static final String LESS_THAN_OPERATOR = "< ";
    private static final String LESS_THAN_EQUALS_OPERATOR = "<= ";
    private static final String NOT_OPERATOR = "not";
    private static final String IS_NOT_NULL_OPERATOR = "is not null";
    private static final String LIKE_OPERATOR = "~";
    private Map<OccurrenceSearchParameter, LinkedList<String>> filter;
    private State state;
    private OccurrenceSearchParameter lastParam;
    private final TitleLookup titleLookup;
    private final ResourceBundle resourceBundle;

    public HumanFilterBuilder(TitleLookup titleLookup) {
        this.titleLookup = titleLookup;
        this.resourceBundle = ResourceBundle.getBundle(DEFAULT_BUNDLE);
    }

    public HumanFilterBuilder(WebResource apiRoot) {
        this.resourceBundle = ResourceBundle.getBundle(DEFAULT_BUNDLE);
        this.titleLookup = new TitleLookup(apiRoot);
    }

    public synchronized Map<OccurrenceSearchParameter, LinkedList<String>> humanFilter(Predicate p) {
        this.filter = Maps.newLinkedHashMap();
        this.state = State.ROOT;
        this.lastParam = null;
        if (p != null) {
            this.visit(p);
        }
        return this.filter;
    }

    public synchronized String humanFilterString(Predicate p) {
        if (p == null) {
            return "All data";
        }
        this.humanFilter(p);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<OccurrenceSearchParameter, LinkedList<String>> entry : this.filter.entrySet()) {
            if (sb.length() > 0) {
                sb.append(" \n");
            }
            sb.append(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, entry.getKey().name()));
            sb.append(": ");
            boolean delimit = false;
            for (String val : entry.getValue()) {
                if (delimit) {
                    sb.append(" or ");
                } else {
                    delimit = true;
                }
                sb.append(val);
            }
        }
        return sb.toString();
    }

    private void addParamValue(OccurrenceSearchParameter param, String op, String value) {
        this.addParamValue(param, op + this.getHumanValue(param, value));
    }

    private String getHumanValue(OccurrenceSearchParameter param, String value) {
        String humanValue;
        switch (param) {
            case TAXON_KEY: 
            case KINGDOM_KEY: 
            case PHYLUM_KEY: 
            case CLASS_KEY: 
            case ORDER_KEY: 
            case FAMILY_KEY: 
            case GENUS_KEY: 
            case SUBGENUS_KEY: 
            case SPECIES_KEY: {
                humanValue = this.titleLookup.getSpeciesName(value);
                break;
            }
            case DATASET_KEY: {
                humanValue = this.titleLookup.getDatasetTitle(value);
                break;
            }
            case COUNTRY: 
            case PUBLISHING_COUNTRY: {
                humanValue = this.lookupCountryCode(value);
                break;
            }
            case CONTINENT: {
                humanValue = this.lookupContinent(value);
                break;
            }
            case MONTH: {
                humanValue = this.lookupMonth(value);
                break;
            }
            default: {
                humanValue = param.type().isEnum() ? this.lookupEnum(param.type(), value) : value;
            }
        }
        if (param == OccurrenceSearchParameter.DEPTH || param == OccurrenceSearchParameter.ELEVATION) {
            humanValue = humanValue + "m";
        }
        return humanValue;
    }

    private String lookupContinent(String value) {
        Continent c = (Continent)VocabularyUtils.lookupEnum((String)value, Continent.class);
        return c.getTitle();
    }

    private void addParamValue(OccurrenceSearchParameter param, String op) {
        if (!this.filter.containsKey(param)) {
            this.filter.put(param, Lists.newLinkedList());
        }
        this.filter.get(param).add(op);
        this.lastParam = param;
    }

    private String lookupEnum(Class clazz, String value) {
        return this.resourceBundle.getString("enum." + clazz.getSimpleName().toLowerCase() + "." + value);
    }

    private String lookupCountryCode(String code) {
        Country c = Country.fromIsoCode((String)code);
        if (c != null) {
            return c.getTitle();
        }
        return code;
    }

    private String lookupMonth(String month) {
        String[] monthRange = month.split("-");
        if (monthRange.length == 2) {
            return this.resourceBundle.getString("enum.month." + monthRange[0]) + "-" + this.resourceBundle.getString("enum.month." + monthRange[1]);
        }
        return this.resourceBundle.getString("enum.month." + month);
    }

    private void visit(ConjunctionPredicate and) throws IllegalStateException {
        try {
            this.visitRange(and);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.state = State.AND;
            for (Predicate p : and.getPredicates()) {
                this.lastParam = null;
                this.visit(p);
            }
            return;
        }
    }

    private void visit(DisjunctionPredicate or) throws IllegalStateException {
        State oldState = this.state;
        if (this.state == State.OR) {
            throw new IllegalStateException("OR within OR filters not supported");
        }
        this.state = State.OR;
        for (Predicate p : or.getPredicates()) {
            this.visit(p);
        }
        this.state = oldState;
    }

    private void visit(EqualsPredicate predicate) {
        this.addParamValue(predicate.getKey(), EQUALS_OPERATOR, predicate.getValue());
    }

    private void visit(GreaterThanOrEqualsPredicate predicate) {
        this.addParamValue(predicate.getKey(), GREATER_THAN_EQUALS_OPERATOR, predicate.getValue());
    }

    private void visit(GreaterThanPredicate predicate) {
        this.addParamValue(predicate.getKey(), GREATER_THAN_OPERATOR, predicate.getValue());
    }

    private void visit(InPredicate in) {
        for (String val : in.getValues()) {
            this.addParamValue(in.getKey(), EQUALS_OPERATOR, val);
        }
    }

    private void visit(LessThanOrEqualsPredicate predicate) {
        this.addParamValue(predicate.getKey(), LESS_THAN_EQUALS_OPERATOR, predicate.getValue());
    }

    private void visit(LessThanPredicate predicate) {
        this.addParamValue(predicate.getKey(), LESS_THAN_OPERATOR, predicate.getValue());
    }

    private void visit(LikePredicate predicate) {
        this.addParamValue(predicate.getKey(), LIKE_OPERATOR, predicate.getValue());
    }

    private void visit(NotPredicate not) throws IllegalStateException {
        if (!(not.getPredicate() instanceof SimplePredicate)) {
            throw new IllegalArgumentException("NOT predicate must be followed by a simple predicate");
        }
        this.visit(not.getPredicate());
        SimplePredicate sp = (SimplePredicate)not.getPredicate();
        String notValue = "not (" + this.filter.get(sp.getKey()).removeLast() + ")";
        this.filter.get(sp.getKey()).add(notValue);
    }

    private void visit(IsNotNullPredicate predicate) {
        this.addParamValue(predicate.getParameter(), IS_NOT_NULL_OPERATOR);
    }

    private void visit(Predicate p) throws IllegalStateException {
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("visit", p.getClass());
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Visit method could not be found. That means a Predicate has been passed in that is unknown to this class", (Throwable)e);
            throw new IllegalArgumentException("Unknown Predicate", e);
        }
        try {
            method.setAccessible(true);
            method.invoke((Object)this, p);
        }
        catch (IllegalAccessException e) {
            LOG.error("This should never happen as we set accessible to true explicitly before. Probably a programming error", (Throwable)e);
            throw new RuntimeException("Programming error", e);
        }
        catch (InvocationTargetException e) {
            LOG.info("Exception thrown while building the human query string", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private void visit(WithinPredicate within) {
        this.addParamValue(OccurrenceSearchParameter.GEOMETRY, EQUALS_OPERATOR, within.getGeometry());
    }

    private void visitRange(ConjunctionPredicate and) {
        if (and.getPredicates().size() != 2) {
            throw new IllegalArgumentException("no valid range");
        }
        GreaterThanOrEqualsPredicate lower = null;
        LessThanOrEqualsPredicate upper = null;
        for (Predicate p : and.getPredicates()) {
            if (p instanceof GreaterThanOrEqualsPredicate) {
                lower = (GreaterThanOrEqualsPredicate)p;
                continue;
            }
            if (!(p instanceof LessThanOrEqualsPredicate)) continue;
            upper = (LessThanOrEqualsPredicate)p;
        }
        if (lower == null || upper == null || lower.getKey() != upper.getKey()) {
            throw new IllegalArgumentException("no valid range");
        }
        this.addParamValue(lower.getKey(), EQUALS_OPERATOR, lower.getValue() + "-" + upper.getValue());
    }

    private static enum State {
        ROOT,
        AND,
        OR;

    }
}

