/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.transactional;

import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.mybatis.guice.transactional.TransactionAttribute;
import org.mybatis.guice.transactional.TransactionToken;
import org.mybatis.guice.transactional.Transactional;

public class TxTransactionalMethodInterceptor
implements MethodInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    @Inject
    private TransactionManager manager;
    @Inject
    private Provider<XAResource> xaResourceProvider;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        TransactionToken tranToken;
        TransactionAttribute attribute;
        Object object;
        String debugPrefix;
        block27: {
            Method interceptedMethod = invocation.getMethod();
            Transactional transactional = interceptedMethod.getAnnotation(Transactional.class);
            if (transactional == null) {
                transactional = interceptedMethod.getDeclaringClass().getAnnotation(Transactional.class);
            }
            debugPrefix = null;
            if (this.log.isDebugEnabled()) {
                debugPrefix = String.format("[Intercepted method: %s]", interceptedMethod.toGenericString());
            }
            boolean needsRollback = transactional.rollbackOnly();
            object = null;
            attribute = null;
            if (this.manager != null) {
                Transactional.TxType txType = transactional.value();
                if (Transactional.TxType.REQUIRED.equals((Object)txType)) {
                    attribute = TransactionAttribute.REQUIRED;
                } else if (Transactional.TxType.REQUIRES_NEW.equals((Object)txType)) {
                    attribute = TransactionAttribute.REQUIRESNEW;
                } else if (Transactional.TxType.MANDATORY.equals((Object)txType)) {
                    attribute = TransactionAttribute.MANDATORY;
                } else if (Transactional.TxType.SUPPORTS.equals((Object)txType)) {
                    attribute = TransactionAttribute.SUPPORTS;
                } else if (Transactional.TxType.NOT_SUPPORTED.equals((Object)txType)) {
                    attribute = null;
                } else if (Transactional.TxType.NEVER.equals((Object)txType)) {
                    attribute = TransactionAttribute.NEVER;
                }
            }
            if (attribute == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("%s - skip Tx Transaction", debugPrefix));
                }
                object = invocation.proceed();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("%s - Tx Transaction %s begin", debugPrefix, attribute.name()));
            }
            tranToken = attribute.begin(this.manager);
            this.log.debug("enlistResource XASqlSessionManager");
            XAResource xaRes = (XAResource)this.xaResourceProvider.get();
            tranToken.getActiveTransaction().enlistResource(xaRes);
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) call method", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
                }
                object = invocation.proceed();
                if (!needsRollback) break block27;
                this.manager.setRollbackOnly();
            }
            catch (Throwable t) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) rolling back", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
                    }
                    this.manager.setRollbackOnly();
                    throw t;
                }
                catch (Throwable throwable) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) finish", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
                    }
                    attribute.finish(this.manager, tranToken);
                    throw throwable;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) finish", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
        }
        attribute.finish(this.manager, tranToken);
        return object;
    }
}

