/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.builtin;

import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.unpooled.UnpooledDataSource;

public final class UnpooledDataSourceProvider
implements Provider<DataSource> {
    private final UnpooledDataSource unpooledDataSource;

    @javax.inject.Inject
    public UnpooledDataSourceProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url, @Named(value="JDBC.driverClassLoader") ClassLoader driverClassLoader) {
        this.unpooledDataSource = new UnpooledDataSource(driverClassLoader, driver, url, null, null);
    }

    @Inject(optional=true)
    public void setUser(@Named(value="JDBC.username") String username) {
        this.unpooledDataSource.setUsername(username);
    }

    @Inject(optional=true)
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.unpooledDataSource.setPassword(password);
    }

    @Inject(optional=true)
    public void setAutoCommit(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.unpooledDataSource.setAutoCommit(Boolean.valueOf(autoCommit));
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        try {
            this.unpooledDataSource.setLoginTimeout(loginTimeout);
        }
        catch (SQLException e) {
            throw new RuntimeException("Impossible to set login timeout '" + loginTimeout + "' to Unpooled Data Source", e);
        }
    }

    @Inject(optional=true)
    public void setDriverProperties(@Named(value="JDBC.driverProperties") Properties driverProperties) {
        this.unpooledDataSource.setDriverProperties(driverProperties);
    }

    public DataSource get() {
        return this.unpooledDataSource;
    }
}

