/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.builtin;

import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.jndi.JndiDataSourceFactory;

public final class JndiDataSourceProvider
implements Provider<DataSource> {
    private final Properties properties = new Properties();

    @Inject
    public JndiDataSourceProvider(@Named(value="jndi.dataSource") String dataSource) {
        this.properties.setProperty("data_source", dataSource);
    }

    @com.google.inject.Inject(optional=true)
    public void setInitialContext(@Named(value="jndi.initialContext") String initialContext) {
        this.properties.setProperty("initial_context", initialContext);
    }

    @com.google.inject.Inject(optional=true)
    public void setEnvInitialContextFactory(@Named(value="java.naming.factory.initial") String initialContextFactory) {
        this.properties.setProperty("env.java.naming.factory.initial", initialContextFactory);
    }

    @com.google.inject.Inject(optional=true)
    public void setEnvProviderURL(@Named(value="java.naming.provider.url") String providerUrl) {
        this.properties.setProperty("env.java.naming.provider.url", providerUrl);
    }

    public DataSource get() {
        JndiDataSourceFactory factory = new JndiDataSourceFactory();
        factory.setProperties(this.properties);
        return factory.getDataSource();
    }
}

