/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.configuration;

import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.guice.configuration.Mappers;
import org.mybatis.guice.configuration.MappingTypeHandlers;
import org.mybatis.guice.configuration.TypeAliases;

@Singleton
public final class ConfigurationProvider
implements Provider<Configuration> {
    private final Environment environment;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.lazyLoadingEnabled")
    private boolean lazyLoadingEnabled = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.aggressiveLazyLoading")
    private boolean aggressiveLazyLoading = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.multipleResultSetsEnabled")
    private boolean multipleResultSetsEnabled = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.useGeneratedKeys")
    private boolean useGeneratedKeys = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.useColumnLabel")
    private boolean useColumnLabel = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.cacheEnabled")
    private boolean cacheEnabled = true;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.defaultExecutorType")
    private ExecutorType defaultExecutorType = ExecutorType.SIMPLE;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.autoMappingBehavior")
    private AutoMappingBehavior autoMappingBehavior = AutoMappingBehavior.PARTIAL;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.failFast")
    private boolean failFast = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.callSettersOnNulls")
    private boolean callSettersOnNulls = false;
    @Inject(optional=true)
    @Named(value="mybatis.configuration.defaultStatementTimeout")
    @Nullable
    private Integer defaultStatementTimeout;
    @javax.inject.Inject
    private ObjectFactory objectFactory;
    @javax.inject.Inject
    private ObjectWrapperFactory objectWrapperFactory;
    @javax.inject.Inject
    private Class<? extends LanguageDriver> defaultScriptingLanguageType;
    @Inject(optional=true)
    @TypeAliases
    private Map<String, Class<?>> typeAliases;
    @Inject(optional=true)
    private Map<Class<?>, TypeHandler<?>> typeHandlers = Collections.emptyMap();
    @Inject(optional=true)
    @MappingTypeHandlers
    private Set<TypeHandler<?>> mappingTypeHandlers = Collections.emptySet();
    @Inject(optional=true)
    @Mappers
    private Set<Class<?>> mapperClasses = Collections.emptySet();
    @Inject(optional=true)
    private Set<Interceptor> plugins = Collections.emptySet();
    @Inject(optional=true)
    @Named(value="mybatis.configuration.mapUnderscoreToCamelCase")
    private boolean mapUnderscoreToCamelCase = false;
    @Inject(optional=true)
    private DatabaseIdProvider databaseIdProvider;
    @Inject
    private DataSource dataSource;

    @Inject
    public ConfigurationProvider(Environment environment) {
        this.environment = environment;
    }

    @Deprecated
    public void setEnvironment(Environment environment) {
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    protected void setAggressiveLazyLoading(boolean aggressiveLazyLoading) {
        this.aggressiveLazyLoading = aggressiveLazyLoading;
    }

    protected void setMultipleResultSetsEnabled(boolean multipleResultSetsEnabled) {
        this.multipleResultSetsEnabled = multipleResultSetsEnabled;
    }

    protected void setUseGeneratedKeys(boolean useGeneratedKeys) {
        this.useGeneratedKeys = useGeneratedKeys;
    }

    protected void setUseColumnLabel(boolean useColumnLabel) {
        this.useColumnLabel = useColumnLabel;
    }

    protected void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    protected void setDefaultExecutorType(ExecutorType defaultExecutorType) {
        this.defaultExecutorType = defaultExecutorType;
    }

    protected void setAutoMappingBehavior(AutoMappingBehavior autoMappingBehavior) {
        this.autoMappingBehavior = autoMappingBehavior;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setCallSettersOnNulls(boolean callSettersOnNulls) {
        this.callSettersOnNulls = callSettersOnNulls;
    }

    public void setDefaultStatementTimeout(Integer defaultStatementTimeout) {
        this.defaultStatementTimeout = defaultStatementTimeout;
    }

    public void setTypeAliases(Map<String, Class<?>> typeAliases) {
        this.typeAliases = typeAliases;
    }

    @Inject(optional=true)
    public void registerTypeHandlers(Map<Class<?>, TypeHandler<?>> typeHandlers) {
        this.typeHandlers = typeHandlers;
    }

    public void setMapperClasses(Set<Class<?>> mapperClasses) {
        this.mapperClasses = mapperClasses;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setWrapperObjectFactory(ObjectWrapperFactory objectWrapperFactory) {
        this.objectWrapperFactory = objectWrapperFactory;
    }

    public void setPlugins(Set<Interceptor> plugins) {
        this.plugins = plugins;
    }

    public void mapUnderscoreToCamelCase(boolean mapUnderscoreToCamelCase) {
        this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
    }

    public Configuration get() {
        Configuration configuration = new Configuration(this.environment);
        configuration.setLazyLoadingEnabled(this.lazyLoadingEnabled);
        configuration.setAggressiveLazyLoading(this.aggressiveLazyLoading);
        configuration.setMultipleResultSetsEnabled(this.multipleResultSetsEnabled);
        configuration.setUseGeneratedKeys(this.useGeneratedKeys);
        configuration.setUseColumnLabel(this.useColumnLabel);
        configuration.setCacheEnabled(this.cacheEnabled);
        configuration.setDefaultExecutorType(this.defaultExecutorType);
        configuration.setAutoMappingBehavior(this.autoMappingBehavior);
        configuration.setObjectFactory(this.objectFactory);
        configuration.setObjectWrapperFactory(this.objectWrapperFactory);
        configuration.setDefaultScriptingLanguage(this.defaultScriptingLanguageType);
        configuration.setMapUnderscoreToCamelCase(this.mapUnderscoreToCamelCase);
        configuration.setCallSettersOnNulls(this.callSettersOnNulls);
        configuration.setDefaultStatementTimeout(this.defaultStatementTimeout);
        try {
            if (this.databaseIdProvider != null) {
                configuration.setDatabaseId(this.databaseIdProvider.getDatabaseId(this.dataSource));
            }
            for (Map.Entry<String, Class<?>> entry : this.typeAliases.entrySet()) {
                configuration.getTypeAliasRegistry().registerAlias(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Class<?>> entry : this.typeHandlers.entrySet()) {
                this.registerTypeHandler(configuration, (Class)entry.getKey(), (TypeHandler)entry.getValue());
            }
            for (TypeHandler typeHandler : this.mappingTypeHandlers) {
                configuration.getTypeHandlerRegistry().register(typeHandler);
            }
            for (Class clazz : this.mapperClasses) {
                if (configuration.hasMapper(clazz)) continue;
                configuration.addMapper(clazz);
            }
            for (Interceptor interceptor : this.plugins) {
                configuration.addInterceptor(interceptor);
            }
            if (this.failFast) {
                configuration.getMappedStatementNames();
            }
        }
        catch (Throwable cause) {
            throw new ProvisionException("An error occurred while building the org.apache.ibatis.session.Configuration", cause);
        }
        finally {
            ErrorContext.instance().reset();
        }
        return configuration;
    }

    private <T> void registerTypeHandler(Configuration configuration, Class<?> type, TypeHandler<?> handler) {
        configuration.getTypeHandlerRegistry().register(type, handler);
    }
}

