/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client.guice;

import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import java.util.Properties;
import org.gbif.api.service.registry.DatasetOccurrenceDownloadUsageService;
import org.gbif.api.service.registry.DatasetProcessStatusService;
import org.gbif.api.service.registry.DatasetSearchService;
import org.gbif.api.service.registry.DatasetService;
import org.gbif.api.service.registry.InstallationService;
import org.gbif.api.service.registry.MetasyncHistoryService;
import org.gbif.api.service.registry.NetworkService;
import org.gbif.api.service.registry.NodeService;
import org.gbif.api.service.registry.OccurrenceDownloadService;
import org.gbif.api.service.registry.OrganizationService;
import org.gbif.registry.doi.registration.DoiRegistrationService;
import org.gbif.registry.ws.client.DatasetOccurrenceDownloadUsageWsClient;
import org.gbif.registry.ws.client.DatasetSearchWsClient;
import org.gbif.registry.ws.client.DatasetWsClient;
import org.gbif.registry.ws.client.DoiRegistrationWsClient;
import org.gbif.registry.ws.client.InstallationWsClient;
import org.gbif.registry.ws.client.NetworkWsClient;
import org.gbif.registry.ws.client.NodeWsClient;
import org.gbif.registry.ws.client.OccurrenceDownloadWsClient;
import org.gbif.registry.ws.client.OrganizationWsClient;
import org.gbif.registry.ws.client.guice.RegistryWs;
import org.gbif.service.guice.PrivateServiceModule;
import org.gbif.ws.client.guice.GbifWsClientModule;
import org.gbif.ws.mixin.Mixins;

public class RegistryWsClientModule
extends GbifWsClientModule {
    public RegistryWsClientModule(Properties properties) {
        super(properties, new Package[]{NodeWsClient.class.getPackage()});
    }

    protected void configureClient() {
        this.install((Module)((Object)new InternalRegistryWsClientModule(this.getProperties())));
        this.expose(NodeService.class);
        this.expose(OrganizationService.class);
        this.expose(InstallationService.class);
        this.expose(DatasetService.class);
        this.expose(DatasetSearchService.class);
        this.expose(NetworkService.class);
        this.expose(OccurrenceDownloadService.class);
        this.expose(DatasetOccurrenceDownloadUsageService.class);
        this.expose(DatasetProcessStatusService.class);
        this.expose(MetasyncHistoryService.class);
        this.expose(DoiRegistrationService.class);
    }

    protected Map<Class<?>, Class<?>> getMixIns() {
        return Mixins.getPredefinedMixins();
    }

    private class InternalRegistryWsClientModule
    extends PrivateServiceModule {
        private static final String PREFIX = "registry.";

        private InternalRegistryWsClientModule(Properties properties) {
            super(PREFIX, properties);
        }

        protected void configureService() {
            this.bind(NodeService.class).to(NodeWsClient.class).in(Scopes.SINGLETON);
            this.bind(OrganizationService.class).to(OrganizationWsClient.class).in(Scopes.SINGLETON);
            this.bind(InstallationService.class).to(InstallationWsClient.class).in(Scopes.SINGLETON);
            this.bind(MetasyncHistoryService.class).to(InstallationWsClient.class).in(Scopes.SINGLETON);
            this.bind(DatasetService.class).to(DatasetWsClient.class).in(Scopes.SINGLETON);
            this.bind(DatasetSearchService.class).to(DatasetSearchWsClient.class).in(Scopes.SINGLETON);
            this.bind(NetworkService.class).to(NetworkWsClient.class).in(Scopes.SINGLETON);
            this.bind(OccurrenceDownloadService.class).to(OccurrenceDownloadWsClient.class).in(Scopes.SINGLETON);
            this.bind(DatasetOccurrenceDownloadUsageService.class).to(DatasetOccurrenceDownloadUsageWsClient.class).in(Scopes.SINGLETON);
            this.bind(DoiRegistrationService.class).to(DoiRegistrationWsClient.class).in(Scopes.SINGLETON);
            this.bind(DatasetProcessStatusService.class).to(DatasetWsClient.class).in(Scopes.SINGLETON);
            this.expose(NodeService.class);
            this.expose(OrganizationService.class);
            this.expose(InstallationService.class);
            this.expose(DatasetService.class);
            this.expose(DatasetSearchService.class);
            this.expose(NetworkService.class);
            this.expose(OccurrenceDownloadService.class);
            this.expose(DatasetOccurrenceDownloadUsageService.class);
            this.expose(DatasetProcessStatusService.class);
            this.expose(MetasyncHistoryService.class);
            this.expose(DoiRegistrationService.class);
        }

        @Provides
        @Singleton
        @RegistryWs
        private WebResource provideBaseWsWebResource(Client client, @Named(value="ws.url") String url) {
            return client.resource(url);
        }
    }
}

