/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.ConfirmationKeyParameter;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Installation;
import org.gbif.api.model.registry.Organization;
import org.gbif.api.model.registry.search.KeyTitleResult;
import org.gbif.api.service.registry.OrganizationService;
import org.gbif.api.vocabulary.Country;
import org.gbif.registry.ws.client.BaseNetworkEntityClient;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.registry.ws.client.guice.RegistryWs;
import org.gbif.ws.client.QueryParamBuilder;

public class OrganizationWsClient
extends BaseNetworkEntityClient<Organization>
implements OrganizationService {
    @Inject
    public OrganizationWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(Organization.class, resource.path("organization"), authFilter, GenericTypes.PAGING_ORGANIZATION);
    }

    public PagingResponse<Dataset> hostedDatasets(UUID organizationKey, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, null, page, new String[]{String.valueOf(organizationKey), "hostedDataset"});
    }

    public PagingResponse<Dataset> publishedDatasets(UUID organizationKey, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, null, page, new String[]{String.valueOf(organizationKey), "publishedDataset"});
    }

    public PagingResponse<Organization> listByCountry(Country country, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, QueryParamBuilder.create((Object[])new Object[]{"country", country}).build(), page, new String[0]);
    }

    public PagingResponse<Installation> installations(UUID organizationKey, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_INSTALLATION, null, null, page, new String[]{String.valueOf(organizationKey), "installation"});
    }

    public PagingResponse<Organization> listDeleted(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, null, page, new String[]{"deleted"});
    }

    public PagingResponse<Organization> listPendingEndorsement(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, null, page, new String[]{"pending"});
    }

    public PagingResponse<Organization> listNonPublishing(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, null, page, new String[]{"nonPublishing"});
    }

    public boolean confirmEndorsement(@NotNull UUID organizationKey, @NotNull UUID confirmationKey) {
        ClientResponse cr = (ClientResponse)this.post(ClientResponse.class, new ConfirmationKeyParameter(confirmationKey), new String[]{String.valueOf(organizationKey), "endorsement"});
        return Response.Status.NO_CONTENT.getStatusCode() == cr.getStatus();
    }

    public List<KeyTitleResult> suggest(@Nullable String q) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.putSingle((Object)"q", (Object)q);
        return (List)this.get(GenericTypes.LIST_KEY_TITLE, null, (MultivaluedMap)queryParams, null, new String[]{"suggest"});
    }
}

