/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.MultivaluedMap;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.occurrence.Download;
import org.gbif.api.model.registry.DatasetOccurrenceDownloadUsage;
import org.gbif.api.service.registry.OccurrenceDownloadService;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.registry.ws.client.guice.RegistryWs;
import org.gbif.ws.client.BaseWsGetClient;

public class OccurrenceDownloadWsClient
extends BaseWsGetClient<Download, String>
implements OccurrenceDownloadService {
    private MultivaluedMap<String, String> buildStatusParam(Set<Download.Status> status) {
        MultivaluedMapImpl statuses = null;
        if (status != null && !status.isEmpty()) {
            statuses = new MultivaluedMapImpl();
            statuses.put((Object)"status", Lists.newArrayList(Collections2.transform(status, new Function<Download.Status, String>(){

                @Override
                @Nullable
                public String apply(@Nullable Download.Status input) {
                    return input.name();
                }
            })));
        }
        return statuses;
    }

    @Inject
    public OccurrenceDownloadWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(Download.class, resource.path("occurrence/download"), authFilter);
    }

    public void update(Download download) {
        this.put(download, new String[]{download.getKey()});
    }

    public void create(Download occurrenceDownload) {
        this.post(occurrenceDownload, new String[]{"/"});
    }

    public PagingResponse<Download> list(@Nullable Pageable page, @Nullable Set<Download.Status> status) {
        return (PagingResponse)this.get(GenericTypes.PAGING_OCCURRENCE_DOWNLOAD, null, this.buildStatusParam(status), page, new String[0]);
    }

    public PagingResponse<Download> listByUser(String user, Pageable page, Set<Download.Status> status) {
        return (PagingResponse)this.get(GenericTypes.PAGING_OCCURRENCE_DOWNLOAD, null, this.buildStatusParam(status), page, new String[]{"user", user});
    }

    public PagingResponse<DatasetOccurrenceDownloadUsage> listDatasetUsages(@NotNull String downloadKey, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET_OCCURRENCE_DOWNLOAD, page, new String[]{downloadKey, "datasets"});
    }
}

