/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Installation;
import org.gbif.api.model.registry.Node;
import org.gbif.api.model.registry.Organization;
import org.gbif.api.service.registry.NodeService;
import org.gbif.api.vocabulary.Country;
import org.gbif.registry.ws.client.BaseNetworkEntityClient;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.registry.ws.client.guice.RegistryWs;

public class NodeWsClient
extends BaseNetworkEntityClient<Node>
implements NodeService {
    @Inject
    public NodeWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(Node.class, resource.path("node"), authFilter, GenericTypes.PAGING_NODE);
    }

    public PagingResponse<Organization> endorsedOrganizations(UUID nodeKey, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, null, page, new String[]{nodeKey.toString(), "organization"});
    }

    public PagingResponse<Organization> pendingEndorsements(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, null, page, new String[]{"pendingEndorsement"});
    }

    public Node getByCountry(Country country) {
        return (Node)this.get(new String[]{"country", country.getIso2LetterCode()});
    }

    public List<Country> listNodeCountries() {
        return (List)this.get(GenericTypes.LIST_COUNTRY, new String[]{"country"});
    }

    public List<Country> listActiveCountries() {
        return (List)this.get(GenericTypes.LIST_COUNTRY, new String[]{"activeCountries"});
    }

    public PagingResponse<Dataset> endorsedDatasets(@NotNull UUID nodeKey, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, page, new String[]{nodeKey.toString(), "dataset"});
    }

    public PagingResponse<Organization> pendingEndorsements(UUID nodeKey, Pageable page) {
        Preconditions.checkNotNull(nodeKey, "Node key required to list the pending endorsements for a given node");
        return (PagingResponse)this.get(GenericTypes.PAGING_ORGANIZATION, null, null, page, new String[]{String.valueOf(nodeKey), "pendingEndorsement"});
    }

    public PagingResponse<Installation> installations(UUID nodeKey, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_INSTALLATION, null, null, page, new String[]{String.valueOf(nodeKey), "installation"});
    }
}

