/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.inject.Inject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Network;
import org.gbif.api.service.registry.NetworkService;
import org.gbif.registry.ws.client.BaseNetworkEntityClient;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.registry.ws.client.guice.RegistryWs;

public class NetworkWsClient
extends BaseNetworkEntityClient<Network>
implements NetworkService {
    @Inject
    public NetworkWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(Network.class, resource.path("network"), authFilter, GenericTypes.PAGING_NETWORK);
    }

    public PagingResponse<Dataset> listConstituents(UUID networkKey, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, page, new String[]{networkKey.toString(), "constituents"});
    }

    public void addConstituent(UUID networkKey, UUID datasetKey) {
        this.post("", new String[]{networkKey.toString(), "constituents", datasetKey.toString()});
    }

    public void removeConstituent(UUID networkKey, UUID datasetKey) {
        this.delete(new String[]{networkKey.toString(), "constituents", datasetKey.toString()});
    }
}

