/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Installation;
import org.gbif.api.model.registry.metasync.MetasyncHistory;
import org.gbif.api.service.registry.InstallationService;
import org.gbif.api.service.registry.MetasyncHistoryService;
import org.gbif.registry.ws.client.BaseNetworkEntityClient;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.registry.ws.client.guice.RegistryWs;

public class InstallationWsClient
extends BaseNetworkEntityClient<Installation>
implements InstallationService,
MetasyncHistoryService {
    @Inject
    public InstallationWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(Installation.class, resource.path("installation"), authFilter, GenericTypes.PAGING_INSTALLATION);
    }

    public PagingResponse<Dataset> getHostedDatasets(UUID installationKey, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, null, page, new String[]{String.valueOf(installationKey), "dataset"});
    }

    public PagingResponse<Installation> listDeleted(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_INSTALLATION, null, null, page, new String[]{"deleted"});
    }

    public PagingResponse<Installation> listNonPublishing(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_INSTALLATION, null, null, page, new String[]{"nonPublishing"});
    }

    public void createMetasync(MetasyncHistory metasyncHistory) {
        Preconditions.checkNotNull(metasyncHistory.getInstallationKey(), "Metasync history needs an installation key");
        this.post(metasyncHistory, new String[]{metasyncHistory.getInstallationKey().toString(), "metasync"});
    }

    public PagingResponse<MetasyncHistory> listMetasync(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.METASYNC_HISTORY, page, new String[]{"metasync"});
    }

    public PagingResponse<MetasyncHistory> listMetasync(UUID installationKey, Pageable page) {
        Preconditions.checkNotNull(installationKey, "Listing metasync for an installation needs an installation key");
        return (PagingResponse)this.get(GenericTypes.METASYNC_HISTORY, page, new String[]{installationKey.toString(), "metasync"});
    }
}

