/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.inject.Inject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import javax.annotation.Nullable;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.common.DoiData;
import org.gbif.registry.doi.DoiType;
import org.gbif.registry.doi.registration.DoiRegistration;
import org.gbif.registry.doi.registration.DoiRegistrationService;
import org.gbif.registry.ws.client.guice.RegistryWs;
import org.gbif.ws.client.BaseWsClient;

public class DoiRegistrationWsClient
extends BaseWsClient
implements DoiRegistrationService {
    @Inject
    public DoiRegistrationWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(resource.path("doi"));
        if (authFilter != null) {
            this.resource.addFilter(authFilter);
        }
    }

    public DOI generate(DoiType doiType) {
        return (DOI)this.getResource(new String[]{"gen", doiType.name()}).type("application/json").post(DOI.class);
    }

    public DoiData get(String prefix, String suffix) {
        return (DoiData)this.getResource(new String[]{prefix, suffix}).type("application/json").get(DoiData.class);
    }

    public void delete(String prefix, String suffix) {
        this.getResource(new String[]{prefix, suffix}).type("application/json").delete();
    }

    public DOI register(DoiRegistration doiRegistration) {
        return (DOI)this.resource.type("application/json").post(DOI.class, (Object)this.toBytes(doiRegistration));
    }

    public DOI update(DoiRegistration doiRegistration) {
        return (DOI)this.resource.type("application/json").put(DOI.class, (Object)this.toBytes(doiRegistration));
    }
}

