/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.crawler.DatasetProcessStatus;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Metadata;
import org.gbif.api.model.registry.Network;
import org.gbif.api.service.registry.DatasetProcessStatusService;
import org.gbif.api.service.registry.DatasetService;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetType;
import org.gbif.api.vocabulary.MetadataType;
import org.gbif.registry.ws.client.BaseNetworkEntityClient;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.registry.ws.client.guice.RegistryWs;
import org.gbif.ws.client.QueryParamBuilder;
import org.gbif.ws.util.InputStreamUtils;

public class DatasetWsClient
extends BaseNetworkEntityClient<Dataset>
implements DatasetService,
DatasetProcessStatusService {
    @Inject
    public DatasetWsClient(@RegistryWs WebResource resource, @Nullable ClientFilter authFilter) {
        super(Dataset.class, resource.path("dataset"), authFilter, GenericTypes.PAGING_DATASET);
    }

    public InputStream getMetadataDocument(UUID datasetKey) {
        return InputStreamUtils.wrapStream((WebResource)this.getResource(new String[]{datasetKey.toString(), "document"}));
    }

    public Metadata insertMetadata(UUID datasetKey, InputStream document) {
        Metadata metadata;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteStreams.copy(document, os);
            metadata = (Metadata)this.getResource(new String[]{datasetKey.toString(), "document"}).type("application/xml").post(Metadata.class, (Object)os.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return metadata;
    }

    public PagingResponse<Dataset> listByCountry(Country country, @Nullable DatasetType type, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, QueryParamBuilder.create((Object[])new Object[]{"country", country, "type", type}).build(), page, new String[0]);
    }

    public PagingResponse<Dataset> listByType(DatasetType type, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, QueryParamBuilder.create((Object[])new Object[]{"type", type}).build(), page, new String[0]);
    }

    public PagingResponse<Dataset> listConstituents(UUID datasetKey, @Nullable Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, page, new String[]{datasetKey.toString(), "constituents"});
    }

    public PagingResponse<Dataset> listConstituents(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, page, new String[]{"constituents"});
    }

    public List<Metadata> listMetadata(UUID datasetKey, @Nullable MetadataType type) {
        return (List)this.get(GenericTypes.LIST_METADATA, QueryParamBuilder.create((Object[])new Object[]{"type", type}).build(), new String[]{datasetKey.toString(), "metadata"});
    }

    public Metadata getMetadata(int metadataKey) {
        return (Metadata)this.get(GenericTypes.METADATA, new String[]{"metadata", String.valueOf(metadataKey)});
    }

    public InputStream getMetadataDocument(int metadataKey) {
        return InputStreamUtils.wrapStream((WebResource)this.getResource(new String[]{"metadata", String.valueOf(metadataKey), "document"}));
    }

    public void deleteMetadata(int metadataKey) {
        this.delete(new String[]{String.valueOf(metadataKey)});
    }

    public PagingResponse<Dataset> listDeleted(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, null, page, new String[]{"deleted"});
    }

    public PagingResponse<Dataset> listDuplicates(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, null, page, new String[]{"duplicate"});
    }

    public PagingResponse<Dataset> listDatasetsWithNoEndpoint(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, null, null, page, new String[]{"withNoEndpoint"});
    }

    public void createDatasetProcessStatus(DatasetProcessStatus datasetProcessStatus) {
        Preconditions.checkNotNull(datasetProcessStatus.getDatasetKey(), "DatasetProcessStatus needs a dataset key");
        this.post(datasetProcessStatus, new String[]{datasetProcessStatus.getDatasetKey().toString(), "process"});
    }

    public void updateDatasetProcessStatus(DatasetProcessStatus datasetProcessStatus) {
        Preconditions.checkNotNull(datasetProcessStatus.getCrawlJob(), "DatasetProcessStatus needs a crawl job");
        Preconditions.checkNotNull(datasetProcessStatus.getDatasetKey(), "DatasetProcessStatus needs a dataset key");
        this.put(datasetProcessStatus, new String[]{datasetProcessStatus.getDatasetKey().toString(), "process", String.valueOf(datasetProcessStatus.getCrawlJob().getAttempt())});
    }

    public DatasetProcessStatus getDatasetProcessStatus(UUID datasetKey, int attempt) {
        Preconditions.checkNotNull(datasetKey, "Dataset key is required");
        return (DatasetProcessStatus)this.get(GenericTypes.DATASET_PROCESS_STATUS, new String[]{datasetKey.toString(), "process", Integer.toString(attempt)});
    }

    public PagingResponse<DatasetProcessStatus> listDatasetProcessStatus(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET_PROCESS_STATUS, page, new String[]{"process"});
    }

    public PagingResponse<DatasetProcessStatus> listDatasetProcessStatus(UUID datasetKey, Pageable page) {
        Preconditions.checkNotNull(datasetKey, "Dataset key is required");
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET_PROCESS_STATUS, page, new String[]{datasetKey.toString(), "process"});
    }

    public PagingResponse<DatasetProcessStatus> listAbortedDatasetProcesses(Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET_PROCESS_STATUS, page, new String[]{"process/aborted"});
    }

    public List<Network> listNetworks(UUID datasetKey) {
        return (List)this.get(GenericTypes.LIST_NETWORK, new String[]{datasetKey.toString(), "networks"});
    }

    public PagingResponse<Dataset> listByDOI(String doi, Pageable page) {
        return (PagingResponse)this.get(GenericTypes.PAGING_DATASET, page, new String[]{"doi", doi});
    }
}

