/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.ws.client;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.map.ObjectMapper;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.Comment;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Endpoint;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.model.registry.MachineTag;
import org.gbif.api.model.registry.NetworkEntity;
import org.gbif.api.model.registry.Tag;
import org.gbif.api.service.registry.NetworkEntityService;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.registry.ws.client.GenericTypes;
import org.gbif.ws.client.BaseWsGetClient;
import org.gbif.ws.client.QueryParamBuilder;

public class BaseNetworkEntityClient<T extends NetworkEntity>
extends BaseWsGetClient<T, UUID>
implements NetworkEntityService<T> {
    private final GenericType<PagingResponse<T>> pagingType;
    private final ObjectMapper mapper = new ObjectMapper();

    public BaseNetworkEntityClient(Class<T> resourceClass, WebResource resource, @Nullable ClientFilter authFilter, GenericType<PagingResponse<T>> pagingType) {
        super(resourceClass, resource, authFilter);
        this.pagingType = pagingType;
    }

    public UUID create(T entity) {
        return (UUID)this.post(UUID.class, entity, new String[]{"/"});
    }

    public void delete(UUID key) {
        this.delete(new String[]{key.toString()});
    }

    public PagingResponse<T> list(Pageable page) {
        return (PagingResponse)this.get(this.pagingType, null, null, page, new String[0]);
    }

    public void update(T entity) {
        this.put(entity, new String[]{entity.getKey().toString()});
    }

    public T get(UUID key) {
        return (T)((NetworkEntity)this.get(new String[]{key.toString()}));
    }

    public Map<UUID, String> getTitles(Collection<UUID> collection) {
        return (Map)this.post(GenericTypes.TITLES_MAP_TYPE, collection, new String[]{"titles"});
    }

    public PagingResponse<T> search(String query, Pageable page) {
        return (PagingResponse)this.get(this.pagingType, null, QueryParamBuilder.create((Object[])new Object[]{"q", query}).build(), page, new String[0]);
    }

    public int addTag(UUID targetEntityKey, Tag tag) {
        return (Integer)this.post(Integer.class, tag, new String[]{targetEntityKey.toString(), "tag"});
    }

    public int addTag(UUID targetEntityKey, String value) {
        return this.addTag(targetEntityKey, new Tag(value));
    }

    public void deleteTag(UUID taggedEntityKey, int tagKey) {
        this.delete(new String[]{taggedEntityKey.toString(), "tag", String.valueOf(tagKey)});
    }

    public List<Tag> listTags(UUID taggedEntityKey, String owner) {
        return (List)this.get(GenericTypes.LIST_TAG, null, null, null, new String[]{taggedEntityKey.toString(), "tag"});
    }

    public int addContact(UUID targetEntityKey, Contact contact) {
        return (Integer)this.post(Integer.class, contact, new String[]{targetEntityKey.toString(), "contact"});
    }

    public void updateContact(UUID targetEntityKey, Contact contact) {
        Preconditions.checkNotNull(contact.getKey(), "Contact key is required to update the contact");
        Preconditions.checkNotNull(targetEntityKey, "The target entity is required to update the contact");
        this.put(contact, new String[]{targetEntityKey.toString(), "contact", contact.getKey().toString()});
    }

    public void deleteContact(UUID targetEntityKey, int contactKey) {
        this.delete(new String[]{targetEntityKey.toString(), "contact", String.valueOf(contactKey)});
    }

    public List<Contact> listContacts(UUID targetEntityKey) {
        return (List)this.get(GenericTypes.LIST_CONTACT, null, null, null, new String[]{targetEntityKey.toString(), "contact"});
    }

    public int addEndpoint(UUID targetEntityKey, Endpoint endpoint) {
        return (Integer)this.post(Integer.class, endpoint, new String[]{targetEntityKey.toString(), "endpoint"});
    }

    public void deleteEndpoint(UUID targetEntityKey, int endpointKey) {
        this.delete(new String[]{targetEntityKey.toString(), "endpoint", String.valueOf(endpointKey)});
    }

    public List<Endpoint> listEndpoints(UUID targetEntityKey) {
        return (List)this.get(GenericTypes.LIST_ENDPOINT, null, null, null, new String[]{targetEntityKey.toString(), "endpoint"});
    }

    public int addMachineTag(UUID targetEntityKey, MachineTag machineTag) {
        int tagId;
        try {
            tagId = (Integer)this.getResource().path(targetEntityKey.toString()).path("machineTag").type("application/json").post(Integer.class, (Object)this.mapper.writeValueAsBytes((Object)machineTag));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return tagId;
    }

    public int addMachineTag(@NotNull UUID targetEntityKey, @NotNull String namespace, @NotNull String name, @NotNull String value) {
        return this.addMachineTag(targetEntityKey, new MachineTag(namespace, name, value));
    }

    public void deleteMachineTag(UUID targetEntityKey, int machineTagKey) {
        this.delete(new String[]{targetEntityKey.toString(), "machineTag", String.valueOf(machineTagKey)});
    }

    public void deleteMachineTags(@NotNull UUID targetEntityKey, @NotNull String namespace) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void deleteMachineTags(@NotNull UUID targetEntityKey, @NotNull String namespace, @NotNull String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<MachineTag> listMachineTags(UUID targetEntityKey) {
        return (List)this.get(GenericTypes.LIST_MACHINETAG, null, null, null, new String[]{targetEntityKey.toString(), "machineTag"});
    }

    public int addComment(UUID targetEntityKey, Comment comment) {
        return (Integer)this.post(Integer.class, comment, new String[]{targetEntityKey.toString(), "comment"});
    }

    public void deleteComment(UUID targetEntityKey, int commentKey) {
        this.delete(new String[]{targetEntityKey.toString(), "comment", String.valueOf(commentKey)});
    }

    public List<Comment> listComments(UUID targetEntityKey) {
        return (List)this.get(GenericTypes.LIST_COMMENT, null, null, null, new String[]{targetEntityKey.toString(), "comment"});
    }

    public int addIdentifier(UUID targetEntityKey, Identifier identifier) {
        return (Integer)this.post(Integer.class, identifier, new String[]{targetEntityKey.toString(), "identifier"});
    }

    public void deleteIdentifier(UUID targetEntityKey, int identifierKey) {
        this.delete(new String[]{targetEntityKey.toString(), "identifier", String.valueOf(identifierKey)});
    }

    public List<Identifier> listIdentifiers(UUID targetEntityKey) {
        return (List)this.get(GenericTypes.LIST_IDENTIFIER, null, null, null, new String[]{targetEntityKey.toString(), "identifier"});
    }

    public PagingResponse<T> listByIdentifier(IdentifierType type, String identifier, Pageable page) {
        return (PagingResponse)this.get(this.pagingType, null, QueryParamBuilder.create((Object[])new Object[]{"identifier", identifier, "identifierType", type}).build(), page, new String[0]);
    }

    public PagingResponse<T> listByIdentifier(String identifier, Pageable page) {
        return (PagingResponse)this.get(this.pagingType, null, QueryParamBuilder.create((Object[])new Object[]{"identifier", identifier}).build(), page, new String[0]);
    }
}

