/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class StartCrawlMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final Optional<Integer> priority;

    public StartCrawlMessage(UUID datasetUuid) {
        this(datasetUuid, (Optional<Integer>)Optional.absent());
    }

    @JsonCreator
    public StartCrawlMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="priority") Optional<Integer> priority) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        this.priority = (Optional)Preconditions.checkNotNull(priority, (Object)"priority can't be null");
    }

    public StartCrawlMessage(UUID datasetUuid, int priority) {
        this(datasetUuid, (Optional<Integer>)Optional.of((Object)priority));
    }

    public StartCrawlMessage(UUID datasetUuid, @Nullable Priority priority) {
        this(datasetUuid, (Optional<Integer>)Optional.fromNullable(priority == null ? null : Integer.valueOf(priority.getPriority())));
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public Optional<Integer> getPriority() {
        return this.priority;
    }

    @Override
    public String getRoutingKey() {
        return "crawl.start";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StartCrawlMessage)) {
            return false;
        }
        StartCrawlMessage other = (StartCrawlMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal(this.priority, other.priority);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.priority});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("priority", this.priority).toString();
    }

    public static enum Priority {
        LOW(10),
        NORMAL(0),
        HIGH(-10),
        CRITICAL(-100);

        private final int priority;

        private Priority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

