/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.gbif.common.messaging.api.Message;

public class RegistryChangeMessage
implements Message {
    private static final String ROUTING_KEY = "registry.change";
    private final ChangeType changeType;
    private final Class<?> objectClass;
    private final Object oldObject;
    private final Object newObject;

    @JsonCreator
    public RegistryChangeMessage(@JsonProperty(value="changeType") ChangeType changeType, @JsonProperty(value="objectClass") Class<?> objectClass, @JsonProperty(value="oldObject") Object oldObject, @JsonProperty(value="newObject") Object newObject) {
        this.changeType = changeType;
        this.objectClass = objectClass;
        this.oldObject = oldObject;
        this.newObject = newObject;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="objectClass")
    public Object getOldObject() {
        return this.oldObject;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="objectClass")
    public Object getNewObject() {
        return this.newObject;
    }

    @Override
    public String getRoutingKey() {
        return "registry.change." + this.changeType.toString().toLowerCase() + "." + this.objectClass.getSimpleName().toLowerCase();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegistryChangeMessage)) {
            return false;
        }
        RegistryChangeMessage other = (RegistryChangeMessage)obj;
        return Objects.equal((Object)((Object)this.changeType), (Object)((Object)other.changeType)) && Objects.equal(this.objectClass, other.objectClass) && Objects.equal((Object)this.oldObject, (Object)other.oldObject) && Objects.equal((Object)this.newObject, (Object)other.newObject);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.changeType, this.objectClass, this.oldObject, this.newObject});
    }

    public static enum ChangeType {
        CREATED,
        UPDATED,
        DELETED;

    }
}

