/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.occurrence.Occurrence;
import org.gbif.api.vocabulary.OccurrencePersistenceStatus;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;
import org.gbif.common.messaging.api.messages.OccurrenceDeletionReason;

public class OccurrenceMutatedMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final Integer crawlAttempt;
    private final OccurrencePersistenceStatus status;
    private final Occurrence oldOccurrence;
    private final Occurrence newOccurrence;
    private final OccurrenceDeletionReason deletionReason;
    private final Integer crawlAttemptLastSeen;
    private final Integer latestCrawlAttemptForDataset;

    @JsonCreator
    public OccurrenceMutatedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="status") OccurrencePersistenceStatus status, @Nullable @JsonProperty(value="crawlAttempt") Integer crawlAttempt, @Nullable @JsonProperty(value="oldOccurrence") Occurrence oldOccurrence, @Nullable @JsonProperty(value="newOccurrence") Occurrence newOccurrence, @Nullable @JsonProperty(value="deletionReason") OccurrenceDeletionReason deletionReason, @Nullable @JsonProperty(value="crawlAttemptLastSeen") Integer crawlAttemptLastSeen, @Nullable @JsonProperty(value="latestCrawlAttemptForDataset") Integer latestCrawlAttemptForDataset) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        this.status = (OccurrencePersistenceStatus)Preconditions.checkNotNull((Object)status, (Object)"status can't be null");
        switch (status) {
            case NEW: {
                Preconditions.checkNotNull((Object)newOccurrence, (Object)"newOccurrence can't be null");
                Preconditions.checkArgument((crawlAttempt != null && crawlAttempt > 0 ? 1 : 0) != 0, (Object)"attempt must be greater than 0");
                break;
            }
            case UPDATED: {
                Preconditions.checkNotNull((Object)newOccurrence, (Object)"newOccurrence can't be null for updates");
                Preconditions.checkNotNull((Object)oldOccurrence, (Object)"oldOccurrence can't be null for updates");
                Preconditions.checkArgument((crawlAttempt != null && crawlAttempt > 0 ? 1 : 0) != 0, (Object)"attempt must be greater than 0");
                break;
            }
            case DELETED: {
                Preconditions.checkNotNull((Object)oldOccurrence, (Object)"oldOccurrence can't be null for deletes");
                Preconditions.checkNotNull((Object)((Object)deletionReason), (Object)"deletionReason can't be null for deletes");
                if (deletionReason != OccurrenceDeletionReason.NOT_SEEN_IN_LAST_CRAWL) break;
                Preconditions.checkArgument((crawlAttemptLastSeen != null && crawlAttemptLastSeen > 0 ? 1 : 0) != 0, (Object)"crawlAttemptLastSeen must be greater than 0");
                Preconditions.checkArgument((latestCrawlAttemptForDataset != null && latestCrawlAttemptForDataset > 0 ? 1 : 0) != 0, (Object)"latestCrawlAttemptForDataset must be greater than 0");
                break;
            }
        }
        this.crawlAttempt = crawlAttempt;
        this.newOccurrence = newOccurrence;
        this.oldOccurrence = oldOccurrence;
        this.deletionReason = deletionReason;
        this.crawlAttemptLastSeen = crawlAttemptLastSeen;
        this.latestCrawlAttemptForDataset = latestCrawlAttemptForDataset;
    }

    public static OccurrenceMutatedMessage buildNewMessage(UUID datasetUuid, Occurrence newOccurrence, int crawlAttempt) {
        return new OccurrenceMutatedMessage(datasetUuid, OccurrencePersistenceStatus.NEW, crawlAttempt, null, newOccurrence, null, null, null);
    }

    public static OccurrenceMutatedMessage buildUpdateMessage(UUID datasetUuid, Occurrence oldOccurrence, Occurrence newOccurrence, int crawlAttempt) {
        return new OccurrenceMutatedMessage(datasetUuid, OccurrencePersistenceStatus.UPDATED, crawlAttempt, oldOccurrence, newOccurrence, null, null, null);
    }

    public static OccurrenceMutatedMessage buildDeleteMessage(UUID datasetUuid, Occurrence oldOccurrence, OccurrenceDeletionReason reason, Integer crawlAttemptLastSeen, Integer lastCrawlAttemptForDataset) {
        return new OccurrenceMutatedMessage(datasetUuid, OccurrencePersistenceStatus.DELETED, null, oldOccurrence, null, reason, crawlAttemptLastSeen, lastCrawlAttemptForDataset);
    }

    @Override
    public String getRoutingKey() {
        return "occurrence.interpreted.mutated";
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public Integer getCrawlAttempt() {
        return this.crawlAttempt;
    }

    public OccurrencePersistenceStatus getStatus() {
        return this.status;
    }

    public Occurrence getOldOccurrence() {
        return this.oldOccurrence;
    }

    public Occurrence getNewOccurrence() {
        return this.newOccurrence;
    }

    public OccurrenceDeletionReason getDeletionReason() {
        return this.deletionReason;
    }

    public Integer getCrawlAttemptLastSeen() {
        return this.crawlAttemptLastSeen;
    }

    public Integer getLatestCrawlAttemptForDataset() {
        return this.latestCrawlAttemptForDataset;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.crawlAttempt, this.status, this.oldOccurrence, this.newOccurrence, this.deletionReason, this.crawlAttemptLastSeen, this.latestCrawlAttemptForDataset});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OccurrenceMutatedMessage other = (OccurrenceMutatedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.crawlAttempt, (Object)other.crawlAttempt) && Objects.equal((Object)this.status, (Object)other.status) && Objects.equal((Object)this.oldOccurrence, (Object)other.oldOccurrence) && Objects.equal((Object)this.newOccurrence, (Object)other.newOccurrence) && Objects.equal((Object)((Object)this.deletionReason), (Object)((Object)other.deletionReason)) && Objects.equal((Object)this.crawlAttemptLastSeen, (Object)other.crawlAttemptLastSeen) && Objects.equal((Object)this.latestCrawlAttemptForDataset, (Object)other.latestCrawlAttemptForDataset);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("crawlAttempt", (Object)this.crawlAttempt).add("status", (Object)this.status).add("oldOccurrence", (Object)this.oldOccurrence).add("newOccurrence", (Object)this.newOccurrence).add("deletionReason", (Object)this.deletionReason).add("crawlAttemptLastSeen", (Object)this.crawlAttemptLastSeen).add("latestCrawlAttemptForDataset", (Object)this.latestCrawlAttemptForDataset).toString();
    }
}

