/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.crawler.DwcaValidationReport;
import org.gbif.api.vocabulary.EndpointType;
import org.gbif.api.vocabulary.OccurrenceSchemaType;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class OccurrenceFragmentedMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final byte[] fragment;
    private final OccurrenceSchemaType schemaType;
    private final EndpointType endpointType;
    private final DwcaValidationReport validationReport;

    @JsonCreator
    public OccurrenceFragmentedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="fragment") byte[] fragment, @JsonProperty(value="schemaType") OccurrenceSchemaType schemaType, @JsonProperty(value="endpointType") EndpointType endpointType, @Nullable @JsonProperty(value="validationReport") DwcaValidationReport validationReport) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt must be greater than 0");
        this.attempt = attempt;
        this.fragment = (byte[])Preconditions.checkNotNull((Object)fragment, (Object)"fragment can't be null");
        this.schemaType = (OccurrenceSchemaType)Preconditions.checkNotNull((Object)schemaType, (Object)"schemaType can't be null");
        this.endpointType = (EndpointType)Preconditions.checkNotNull((Object)endpointType, (Object)"endpointType can't be null");
        this.validationReport = validationReport;
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public byte[] getFragment() {
        return this.fragment;
    }

    public OccurrenceSchemaType getSchemaType() {
        return this.schemaType;
    }

    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    public DwcaValidationReport getValidationReport() {
        return this.validationReport;
    }

    @Override
    public String getRoutingKey() {
        return "crawler.fragment.new";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OccurrenceFragmentedMessage)) {
            return false;
        }
        OccurrenceFragmentedMessage other = (OccurrenceFragmentedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Arrays.equals(this.fragment, other.fragment) && Objects.equal((Object)this.schemaType, (Object)other.schemaType) && Objects.equal((Object)this.endpointType, (Object)other.endpointType) && Objects.equal((Object)this.validationReport, (Object)other.validationReport);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, Arrays.hashCode(this.fragment), this.schemaType, this.endpointType, this.validationReport});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("attempt", this.attempt).add("fragment", (Object)this.fragment).add("schemaType", (Object)this.schemaType).add("endpointType", (Object)this.endpointType).add("validationReport", (Object)this.validationReport).toString();
    }
}

