/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.vocabulary.OccurrencePersistenceStatus;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class FragmentPersistedMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final OccurrencePersistenceStatus status;
    private final int occurrenceKey;

    @JsonCreator
    public FragmentPersistedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="status") OccurrencePersistenceStatus status, @JsonProperty(value="occurrenceKey") int occurrenceKey) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt must be greater than 0");
        this.attempt = attempt;
        this.status = (OccurrencePersistenceStatus)Preconditions.checkNotNull((Object)status, (Object)"status can't be null");
        this.occurrenceKey = (Integer)Preconditions.checkNotNull((Object)occurrenceKey, (Object)"occurrenceKey can't be null");
    }

    @Override
    public String getRoutingKey() {
        return "occurrence.fragment.persisted";
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public OccurrencePersistenceStatus getStatus() {
        return this.status;
    }

    public int getOccurrenceKey() {
        return this.occurrenceKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, this.status, this.occurrenceKey});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FragmentPersistedMessage other = (FragmentPersistedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.status, (Object)other.status) && Objects.equal((Object)this.occurrenceKey, (Object)other.occurrenceKey);
    }
}

