/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.crawler.DwcaValidationReport;
import org.gbif.api.vocabulary.DatasetType;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class DwcaValidationFinishedMessage
implements DatasetBasedMessage {
    public static final String ROUTING_KEY = "crawl.dwca.validation.finished";
    private final UUID datasetUuid;
    private final DatasetType datasetType;
    private final URI source;
    private final int attempt;
    private final DwcaValidationReport validationReport;

    @JsonCreator
    public DwcaValidationFinishedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="datasetType") DatasetType datasetType, @JsonProperty(value="source") URI source, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="validationReport") DwcaValidationReport validationReport) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        this.datasetType = (DatasetType)Preconditions.checkNotNull((Object)datasetType, (Object)"datasetType can't be null");
        this.source = (URI)Preconditions.checkNotNull((Object)source, (Object)"source can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        this.validationReport = (DwcaValidationReport)Preconditions.checkNotNull((Object)validationReport, (Object)"validationReport can't be null");
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public DatasetType getDatasetType() {
        return this.datasetType;
    }

    public URI getSource() {
        return this.source;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public DwcaValidationReport getValidationReport() {
        return this.validationReport;
    }

    @Override
    public String getRoutingKey() {
        return ROUTING_KEY;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.datasetType, this.source, this.attempt, this.validationReport});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DwcaValidationFinishedMessage other = (DwcaValidationFinishedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.datasetType, (Object)other.datasetType) && Objects.equal((Object)this.source, (Object)other.source) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.validationReport, (Object)other.validationReport);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("datasetType", (Object)this.datasetType).add("source", (Object)this.source).add("attempt", this.attempt).add("validationReport", (Object)this.validationReport).toString();
    }
}

