/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class DwcaDownloadFinishedMessage
implements DatasetBasedMessage {
    public static final String ROUTING_KEY = "crawl.dwca.download.finished";
    private final UUID datasetUuid;
    private final URI source;
    private final int attempt;
    private final Optional<Date> lastModified;
    private final boolean modified;

    @JsonCreator
    public DwcaDownloadFinishedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="source") URI source, @JsonProperty(value="attempt") int attempt, @Nullable @JsonProperty(value="lastModified") Date lastModified, @JsonProperty(value="modified") boolean modified) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        this.source = (URI)Preconditions.checkNotNull((Object)source, (Object)"source can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        this.lastModified = Optional.fromNullable((Object)lastModified);
        this.modified = modified;
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public URI getSource() {
        return this.source;
    }

    public int getAttempt() {
        return this.attempt;
    }

    @Nullable
    public Date getLastModified() {
        return (Date)this.lastModified.orNull();
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public String getRoutingKey() {
        return ROUTING_KEY;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DwcaDownloadFinishedMessage)) {
            return false;
        }
        DwcaDownloadFinishedMessage other = (DwcaDownloadFinishedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.source, (Object)other.source) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal(this.lastModified, other.lastModified) && Objects.equal((Object)this.modified, (Object)other.modified);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.source, this.attempt, this.lastModified, this.modified});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("source", (Object)this.source).add("attempt", this.attempt).add("lastModified", this.lastModified).add("modified", this.modified).toString();
    }
}

