/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.Message;
import org.gbif.common.messaging.api.messages.OccurrenceDeletionReason;

public class DeleteOccurrenceMessage
implements Message {
    private final int occurrenceKey;
    private final OccurrenceDeletionReason deletionReason;
    private final Integer crawlAttemptLastSeen;
    private final Integer latestCrawlAttemptForDataset;

    @JsonCreator
    public DeleteOccurrenceMessage(@JsonProperty(value="occurrenceKey") int occurrenceKey, @JsonProperty(value="deletionReason") OccurrenceDeletionReason deletionReason, @Nullable @JsonProperty(value="crawlAttemptLastSeen") Integer crawlAttemptLastSeen, @Nullable @JsonProperty(value="latestCrawlAttemptForDataset") Integer latestCrawlAttemptForDataset) {
        Preconditions.checkArgument((occurrenceKey > 0 ? 1 : 0) != 0, (Object)"occurrenceKey must be greater than 0");
        this.occurrenceKey = occurrenceKey;
        this.deletionReason = (OccurrenceDeletionReason)((Object)Preconditions.checkNotNull((Object)((Object)deletionReason), (Object)"deletionReason can't be null"));
        if (deletionReason == OccurrenceDeletionReason.NOT_SEEN_IN_LAST_CRAWL) {
            Preconditions.checkArgument((crawlAttemptLastSeen != null && crawlAttemptLastSeen > 0 ? 1 : 0) != 0, (Object)"crawlAttemptLastSeen must be greater than 0");
            Preconditions.checkArgument((latestCrawlAttemptForDataset != null && latestCrawlAttemptForDataset > 0 ? 1 : 0) != 0, (Object)"latestCrawlAttemptForDataset must be greater than 0");
        }
        this.crawlAttemptLastSeen = crawlAttemptLastSeen;
        this.latestCrawlAttemptForDataset = latestCrawlAttemptForDataset;
    }

    @Override
    public String getRoutingKey() {
        return "occurrence.delete.occurrence";
    }

    public int getOccurrenceKey() {
        return this.occurrenceKey;
    }

    public OccurrenceDeletionReason getDeletionReason() {
        return this.deletionReason;
    }

    public Integer getCrawlAttemptLastSeen() {
        return this.crawlAttemptLastSeen;
    }

    public Integer getLatestCrawlAttemptForDataset() {
        return this.latestCrawlAttemptForDataset;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.occurrenceKey, this.deletionReason, this.crawlAttemptLastSeen, this.latestCrawlAttemptForDataset});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteOccurrenceMessage other = (DeleteOccurrenceMessage)obj;
        return Objects.equal((Object)this.occurrenceKey, (Object)other.occurrenceKey) && Objects.equal((Object)((Object)this.deletionReason), (Object)((Object)other.deletionReason)) && Objects.equal((Object)this.crawlAttemptLastSeen, (Object)other.crawlAttemptLastSeen) && Objects.equal((Object)this.latestCrawlAttemptForDataset, (Object)other.latestCrawlAttemptForDataset);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("occurrenceKey", this.occurrenceKey).add("deletionReason", (Object)this.deletionReason).add("crawlAttemptLastSeen", (Object)this.crawlAttemptLastSeen).add("latestCrawlAttemptForDataset", (Object)this.latestCrawlAttemptForDataset).toString();
    }
}

