/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;
import org.gbif.common.messaging.api.messages.OccurrenceDeletionReason;

public class DeleteDatasetOccurrencesMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final OccurrenceDeletionReason deletionReason;

    @JsonCreator
    public DeleteDatasetOccurrencesMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="deletionReason") OccurrenceDeletionReason deletionReason) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        this.deletionReason = (OccurrenceDeletionReason)((Object)Preconditions.checkNotNull((Object)((Object)deletionReason), (Object)"deletionReason can't be null"));
    }

    @Override
    public String getRoutingKey() {
        return "occurrence.delete.dataset";
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public OccurrenceDeletionReason getDeletionReason() {
        return this.deletionReason;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteDatasetOccurrencesMessage other = (DeleteDatasetOccurrencesMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid);
    }
}

