/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class CrawlStartedMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final URI targetUrl;
    private final String status;

    @JsonCreator
    public CrawlStartedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="targetUrl") URI targetUrl, @JsonProperty(value="status") String status) {
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        this.targetUrl = (URI)Preconditions.checkNotNull((Object)targetUrl, (Object)"targetUrl can't be null");
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status can't be null");
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public URI getTargetUrl() {
        return this.targetUrl;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String getRoutingKey() {
        return "crawl.started";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrawlStartedMessage)) {
            return false;
        }
        CrawlStartedMessage other = (CrawlStartedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.targetUrl, (Object)other.targetUrl) && Objects.equal((Object)this.status, (Object)other.status);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, this.targetUrl, this.status});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("attempt", this.attempt).add("targetUrl", (Object)this.targetUrl).add("status", (Object)this.status).toString();
    }
}

