/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class CrawlResponseMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final int requestTry;
    private final byte[] response;
    private final long duration;
    private final Optional<Integer> recordCount;
    private final String status;

    @JsonCreator
    public CrawlResponseMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="requestTry") int requestTry, @JsonProperty(value="response") byte[] response, @JsonProperty(value="duration") long duration, @JsonProperty(value="recordCount") Optional<Integer> recordCount, @JsonProperty(value="status") String status) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid);
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        Preconditions.checkArgument((requestTry > 0 ? 1 : 0) != 0, (Object)"requestTry has to be greater than 0");
        this.requestTry = requestTry;
        this.response = (byte[])Preconditions.checkNotNull((Object)response, (Object)"response can't be null");
        Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (Object)"duration has to be greater than 0");
        this.duration = duration;
        this.recordCount = (Optional)Preconditions.checkNotNull(recordCount, (Object)"recordCount can't be null");
        Preconditions.checkArgument((!recordCount.isPresent() || (Integer)recordCount.get() >= 0 ? 1 : 0) != 0, (Object)"recordCount has to be absent or greater than or equal to 0");
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status can't be null");
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public long getDuration() {
        return this.duration;
    }

    public Optional<Integer> getRecordCount() {
        return this.recordCount;
    }

    public int getRequestTry() {
        return this.requestTry;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String getRoutingKey() {
        return "crawl.response";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrawlResponseMessage)) {
            return false;
        }
        CrawlResponseMessage other = (CrawlResponseMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.requestTry, (Object)other.requestTry) && Arrays.equals(this.response, other.response) && Objects.equal((Object)this.duration, (Object)other.duration) && Objects.equal(this.recordCount, other.recordCount) && Objects.equal((Object)this.status, (Object)other.status);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, this.requestTry, Arrays.hashCode(this.response), this.duration, this.recordCount, this.status});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("attempt", this.attempt).add("requestTry", this.requestTry).add("response", (Object)this.response).add("duration", this.duration).add("recordCount", this.recordCount).add("status", (Object)this.status).toString();
    }
}

