/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class CrawlRequestMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final int requestTry;
    private final byte[] request;
    private final String status;

    @JsonCreator
    public CrawlRequestMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="requestTry") int requestTry, @JsonProperty(value="request") byte[] request, @JsonProperty(value="status") String status) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        Preconditions.checkArgument((requestTry > 0 ? 1 : 0) != 0, (Object)"requestTry has to be greater than 0");
        this.requestTry = requestTry;
        this.request = (byte[])Preconditions.checkNotNull((Object)request, (Object)"request can't be null");
        this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status can't be null");
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public int getRequestTry() {
        return this.requestTry;
    }

    public byte[] getRequest() {
        return this.request;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String getRoutingKey() {
        return "crawl.request";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrawlRequestMessage)) {
            return false;
        }
        CrawlRequestMessage other = (CrawlRequestMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.requestTry, (Object)other.requestTry) && Arrays.equals(this.request, other.request) && Objects.equal((Object)this.status, (Object)other.status);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, this.requestTry, Arrays.hashCode(this.request), this.status});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("attempt", this.attempt).add("requestTry", this.requestTry).add("request", (Object)this.request).add("status", (Object)this.status).toString();
    }
}

