/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.crawler.FinishReason;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class CrawlFinishedMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final int totalRecordCount;
    private final FinishReason reason;

    @JsonCreator
    public CrawlFinishedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="totalRecordCount") int totalRecordCount, @JsonProperty(value="reason") FinishReason reason) {
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        Preconditions.checkArgument((totalRecordCount >= 0 ? 1 : 0) != 0, (Object)"totalRecordCount has to be greater than or equal to 0");
        this.totalRecordCount = totalRecordCount;
        this.reason = (FinishReason)Preconditions.checkNotNull((Object)reason, (Object)"reason can't be null");
    }

    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public FinishReason getReason() {
        return this.reason;
    }

    public int getTotalRecordCount() {
        return this.totalRecordCount;
    }

    @Override
    public String getRoutingKey() {
        return "crawl.finished";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrawlFinishedMessage)) {
            return false;
        }
        CrawlFinishedMessage other = (CrawlFinishedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.totalRecordCount, (Object)other.totalRecordCount) && Objects.equal((Object)this.reason, (Object)other.reason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, this.totalRecordCount, this.reason});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("attempt", this.attempt).add("totalRecordCount", this.totalRecordCount).add("reason", (Object)this.reason).toString();
    }
}

