/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class CrawlErrorMessage
implements DatasetBasedMessage {
    private final UUID datasetUuid;
    private final int attempt;
    private final int retry;
    private final int offset;
    private final String status;
    private final ErrorType errorType;
    private final Optional<Throwable> throwable;
    private final long duration;

    @JsonCreator
    public CrawlErrorMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="retry") int retry, @JsonProperty(value="offset") int offset, @JsonProperty(value="duration") long duration, @JsonProperty(value="status") String status, @JsonProperty(value="errorType") ErrorType errorType, @Nullable @JsonProperty(value="throwable") Throwable throwable) {
        this.duration = duration;
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid);
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        Preconditions.checkArgument((retry > 0 ? 1 : 0) != 0, (Object)"retry has to be greater than 0");
        this.retry = retry;
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset has to be greater than or equal to 0");
        this.offset = offset;
        this.status = (String)Preconditions.checkNotNull((Object)status);
        this.errorType = (ErrorType)((Object)Preconditions.checkNotNull((Object)((Object)errorType)));
        this.throwable = Optional.fromNullable((Object)throwable);
    }

    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public long getDuration() {
        return this.duration;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRetry() {
        return this.retry;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String getRoutingKey() {
        return "crawl.error" + this.errorType.toString().toLowerCase();
    }

    public Optional<Throwable> getThrowable() {
        return this.throwable;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrawlErrorMessage other = (CrawlErrorMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal((Object)this.retry, (Object)other.retry) && Objects.equal((Object)this.offset, (Object)other.offset) && Objects.equal((Object)this.status, (Object)other.status) && Objects.equal((Object)((Object)this.errorType), (Object)((Object)other.errorType)) && Objects.equal((Object)this.duration, (Object)other.duration);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.attempt, this.retry, this.offset, this.status, this.errorType, this.duration});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetUuid", (Object)this.datasetUuid).add("attempt", this.attempt).add("retry", this.retry).add("offset", this.offset).add("status", (Object)this.status).add("errorType", (Object)this.errorType).add("throwable", this.throwable).add("duration", this.duration).toString();
    }

    public static enum ErrorType {
        PROTOCOL,
        TRANSPORT,
        OTHER,
        UNKNOWN;

    }
}

