/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.common.messaging.api.messages.DatasetBasedMessage;

public class ChecklistSyncedMessage
implements DatasetBasedMessage {
    public static final String ROUTING_KEY = "checklist.imported";
    private final UUID datasetUuid;
    private final Date crawlFinished;
    private final int recordsSynced;
    private final int recordsDeleted;

    @JsonCreator
    public ChecklistSyncedMessage(@JsonProperty(value="datasetUuid") UUID datasetUuid, @JsonProperty(value="crawlFinished") Date crawlFinished, @JsonProperty(value="recordsSynced") int recordsSynced, @JsonProperty(value="recordsDeleted") int recordsDeleted) {
        this.crawlFinished = (Date)Preconditions.checkNotNull((Object)crawlFinished, (Object)"crawlFinished date missing");
        Preconditions.checkArgument((recordsSynced >= 0 ? 1 : 0) != 0);
        this.recordsSynced = recordsSynced;
        Preconditions.checkArgument((recordsDeleted >= 0 ? 1 : 0) != 0);
        this.recordsDeleted = recordsDeleted;
        this.datasetUuid = (UUID)Preconditions.checkNotNull((Object)datasetUuid, (Object)"datasetUuid can't be null");
    }

    @Override
    public String getRoutingKey() {
        return ROUTING_KEY;
    }

    @Override
    public UUID getDatasetUuid() {
        return this.datasetUuid;
    }

    public Date getCrawlFinished() {
        return this.crawlFinished;
    }

    public int getRecordsSynced() {
        return this.recordsSynced;
    }

    public int getRecordsDeleted() {
        return this.recordsDeleted;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetUuid, this.crawlFinished, this.recordsSynced, this.recordsDeleted});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChecklistSyncedMessage other = (ChecklistSyncedMessage)obj;
        return Objects.equal((Object)this.datasetUuid, (Object)other.datasetUuid) && Objects.equal((Object)this.crawlFinished, (Object)other.crawlFinished) && Objects.equal((Object)this.recordsSynced, (Object)other.recordsSynced) && Objects.equal((Object)this.recordsDeleted, (Object)other.recordsDeleted);
    }
}

