/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging.api.messages;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.common.DoiStatus;
import org.gbif.common.messaging.api.Message;

public class ChangeDoiMessage
implements Message {
    public static final String ROUTING_KEY = "doi.change";
    private final DOI doi;
    private final DoiStatus status;
    private final String metadata;
    private final URI target;

    @JsonCreator
    public ChangeDoiMessage(@JsonProperty(value="status") DoiStatus status, @JsonProperty(value="doi") DOI doi, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="target") URI target) {
        this.status = (DoiStatus)Preconditions.checkNotNull((Object)status, (Object)"status can't be null");
        this.doi = (DOI)Preconditions.checkNotNull((Object)doi, (Object)"doi can't be null");
        if (status != DoiStatus.DELETED) {
            Preconditions.checkNotNull((Object)metadata, (Object)"metadata can't be null");
        }
        this.metadata = metadata;
        if (status == DoiStatus.REGISTERED) {
            Preconditions.checkNotNull((Object)target, (Object)"target URI can't be null");
        }
        this.target = target;
    }

    public DOI getDoi() {
        return this.doi;
    }

    public DoiStatus getStatus() {
        return this.status;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public URI getTarget() {
        return this.target;
    }

    @Override
    public String getRoutingKey() {
        return ROUTING_KEY;
    }

    public int hashCode() {
        return Objects.hash(this.doi, this.status, this.metadata, this.target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeDoiMessage other = (ChangeDoiMessage)obj;
        return Objects.equals(this.doi, other.doi) && Objects.equals(this.status, other.status) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.target, other.target);
    }
}

