/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import org.gbif.common.messaging.ForwardingMessagePublisher;
import org.gbif.common.messaging.api.MessagePublisher;

public class RateLimitingMessagePublisher
extends ForwardingMessagePublisher {
    private final RateLimiter rateLimiter;

    public RateLimitingMessagePublisher(MessagePublisher delegate, int requestsPerSecond) {
        super(delegate);
        Preconditions.checkArgument((requestsPerSecond > 0 ? 1 : 0) != 0, (Object)"requestsPerSecond has to be greater than zero");
        this.rateLimiter = RateLimiter.create((double)requestsPerSecond);
    }

    @Override
    public void send(Object message, String exchange, String routingKey) throws IOException {
        this.rateLimiter.acquire();
        super.send(message, exchange, routingKey);
    }
}

