/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.gbif.common.messaging.ConnectionParameters;
import org.gbif.common.messaging.DefaultMessageRegistry;
import org.gbif.common.messaging.MessageConsumer;
import org.gbif.common.messaging.api.Message;
import org.gbif.common.messaging.api.MessageCallback;
import org.gbif.common.messaging.api.MessageRegistry;
import org.gbif.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListener
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MessageListener.class);
    private static final int DEFAULT_PREFETCH_COUNT = 50;
    private final int prefetchCount;
    private final ConnectionFactory connectionFactory;
    private final MessageRegistry registry;
    private final ObjectMapper mapper;

    public MessageListener(ConnectionParameters connectionParameters) throws IOException {
        this(connectionParameters, new DefaultMessageRegistry(), new ObjectMapper(), 50);
    }

    public MessageListener(ConnectionParameters connectionParameters, int prefetchCount) throws IOException {
        this(connectionParameters, new DefaultMessageRegistry(), new ObjectMapper(), prefetchCount);
    }

    public MessageListener(ConnectionParameters connectionParameters, MessageRegistry registry, ObjectMapper mapper) throws IOException {
        this(connectionParameters, registry, mapper, 50);
    }

    public MessageListener(ConnectionParameters connectionParameters, MessageRegistry registry, ObjectMapper mapper, int prefetchCount) throws IOException {
        Preconditions.checkNotNull((Object)connectionParameters, (Object)"connectionParameters can't be null");
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"mapper can't be null");
        this.registry = (MessageRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry can't be null");
        Preconditions.checkArgument((prefetchCount >= 1 ? 1 : 0) != 0, (Object)"prefetchCount needs to be greater than or equal to 1");
        this.prefetchCount = prefetchCount;
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LOG.info("Connecting to AMQP broker {}", (Object)connectionParameters);
        this.connectionFactory = connectionParameters.getConnectionFactory();
        Connection connection = this.connectionFactory.newConnection();
        connection.close();
        mapper.registerModule((Module)new GuavaModule());
    }

    public <T extends Message> void listen(String queue, int numberOfThreads, MessageCallback<T> callback) throws IOException {
        Preconditions.checkNotNull(callback, (Object)"callback can't be null");
        Optional<String> routingKey = this.registry.getGenericRoutingKey(callback.getMessageClass());
        Preconditions.checkArgument((boolean)routingKey.isPresent(), (Object)"The message needs to be registered");
        this.listen(queue, (String)routingKey.get(), numberOfThreads, callback);
    }

    public <T extends Message> void listen(String queue, String routingKey, int numberOfThreads, MessageCallback<T> callback) throws IOException {
        Preconditions.checkNotNull(callback, (Object)"callback can't be null");
        Optional<String> exchange = this.registry.getExchange(callback.getMessageClass());
        Preconditions.checkArgument((boolean)exchange.isPresent(), (Object)"The message needs to be registered");
        this.listen(queue, routingKey, (String)exchange.get(), numberOfThreads, callback);
    }

    public <T> void listen(String queue, String routingKey, String exchange, int numberOfThreads, MessageCallback<T> callback) throws IOException {
        Preconditions.checkNotNull((Object)queue, (Object)"queue can't be null");
        Preconditions.checkNotNull((Object)routingKey, (Object)"routingKey can't be null");
        Preconditions.checkNotNull(callback, (Object)"callback can't be empty");
        Preconditions.checkArgument((numberOfThreads >= 1 ? 1 : 0) != 0, (Object)"numberOfThreads needs to be greater than or equal to 1");
        Connection connection = this.connectionFactory.newConnection(Executors.newFixedThreadPool(numberOfThreads, (ThreadFactory)new NamedThreadFactory(queue)));
        Channel channel = connection.createChannel();
        channel.exchangeDeclare(exchange, "topic", true);
        channel.queueDeclare(queue, true, false, false, null);
        channel.queueBind(queue, exchange, routingKey);
        channel.close();
        LOG.debug("Starting to listen on exchange [{}], queue [{}] and routing key [{}] for messages of type [{}]", new Object[]{exchange, queue, routingKey, callback.getMessageClass().getSimpleName()});
        for (int i = 0; i < numberOfThreads; ++i) {
            channel = connection.createChannel();
            channel.basicQos(this.prefetchCount);
            channel.basicConsume(queue, false, new MessageConsumer<T>(callback.getMessageClass(), channel, this.mapper, callback));
        }
    }

    @Override
    public void close() {
    }
}

