/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.google.common.base.Preconditions;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.gbif.common.messaging.api.MessageCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class MessageConsumer<T>
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MessageConsumer.class);
    private final MessageCallback<T> callback;
    private final Class<T> clazz;
    private final ObjectMapper mapper;

    MessageConsumer(Class<T> clazz, Channel channel, ObjectMapper mapper, MessageCallback<T> callback) {
        super(channel);
        Preconditions.checkNotNull((Object)channel, (Object)"channel can't be null");
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz can't be null");
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"mapper can't be null");
        this.callback = (MessageCallback)Preconditions.checkNotNull(callback, (Object)"callback can't be null");
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        LOG.debug("Handling delivery: [{}]", (Object)envelope.getDeliveryTag());
        T object = this.deserializeBody(envelope, body);
        if (object == null) {
            this.getChannel().basicReject(envelope.getDeliveryTag(), false);
        } else {
            this.handleCallback(envelope, object);
        }
    }

    private T deserializeBody(Envelope envelope, byte[] body) throws IOException {
        Object object = null;
        try {
            object = this.mapper.readValue(body, this.clazz);
        }
        catch (JsonMappingException e) {
            LOG.warn("Could not map message. Supposed to be of type [{}]. Routing key [{}], exchange [{}]", new Object[]{this.clazz.getSimpleName(), envelope.getRoutingKey(), envelope.getExchange(), e});
        }
        catch (JsonParseException e) {
            LOG.warn("Could not parse body of message. Supposed to be of type [{}]. Routing key [{}], exchange [{}]", new Object[]{this.clazz.getSimpleName(), envelope.getRoutingKey(), envelope.getExchange(), e});
        }
        catch (IOException e) {
            LOG.warn("Unable to read message over network. Supposed to be of type [{}]. Routing key [{}], exchange [{}]", new Object[]{this.clazz.getSimpleName(), envelope.getRoutingKey(), envelope.getExchange(), e});
        }
        return (T)object;
    }

    private void handleCallback(Envelope envelope, T object) {
        try {
            this.callback.handleMessage(object);
        }
        catch (Exception e) {
            LOG.warn("Error handling message [{}] of type [{}]. Reject and send a nack", new Object[]{envelope.getDeliveryTag(), object.getClass().getSimpleName(), e});
            try {
                this.getChannel().basicNack(envelope.getDeliveryTag(), false, false);
            }
            catch (IOException e1) {
                LOG.warn("Failed to nack message [{}] of type [{}]", new Object[]{envelope.getDeliveryTag(), object.getClass().getSimpleName(), e1});
            }
            return;
        }
        try {
            this.getChannel().basicAck(envelope.getDeliveryTag(), false);
        }
        catch (IOException e) {
            LOG.warn("Failure acknowledging message [{}] of type [{}]", new Object[]{envelope.getDeliveryTag(), object.getClass().getSimpleName(), e});
        }
    }
}

