/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.messaging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import java.io.IOException;
import org.gbif.common.messaging.api.Message;
import org.gbif.common.messaging.api.MessagePublisher;

public class ForwardingMessagePublisher
extends ForwardingObject
implements MessagePublisher {
    private final MessagePublisher delegate;

    protected ForwardingMessagePublisher(MessagePublisher delegate) {
        this.delegate = (MessagePublisher)Preconditions.checkNotNull((Object)delegate, (Object)"delegate can't be null");
    }

    @Override
    public void send(Message message) throws IOException {
        this.delegate().send(message);
    }

    @Override
    public void send(Message message, boolean persistent) throws IOException {
        this.delegate().send(message, persistent);
    }

    @Override
    public void send(Message message, String exchange) throws IOException {
        this.delegate().send(message, exchange);
    }

    @Override
    public void send(Object message, String exchange, String routingKey) throws IOException {
        this.delegate().send(message, exchange, routingKey);
    }

    @Override
    public void send(Object message, String exchange, String routingKey, boolean persistent) throws IOException {
        this.delegate().send(message, exchange, routingKey, persistent);
    }

    protected MessagePublisher delegate() {
        return this.delegate;
    }

    @Override
    public void close() {
        this.delegate().close();
    }
}

